/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.config.simple;

import com.mojang.serialization.Codec;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.config.client.simple.ClientConfigRegistry;
import de.cristelknight.cristellib.config.simple.ConfigHolder;
import de.cristelknight.cristellib.config.simple.ConfigSettings;
import de.cristelknight.cristellib.util.Util;
import java.util.HashMap;
import java.util.Map;

public class ConfigRegistry {
    private static final Map<Class<?>, ConfigHolder<?>> CONFIGS = new HashMap();

    public static <T> void register(Class<T> clazz, ConfigSettings<T> spec) {
        CONFIGS.put(clazz, new ConfigHolder<T>(spec));
        ConfigRegistry.get(clazz);
    }

    public static <T> void registerWithScreen(Class<T> clazz, ConfigSettings<T> spec, String modIdForScreen, String screenName) {
        ConfigRegistry.registerWithScreen(clazz, spec, modIdForScreen, screenName, () -> {});
    }

    public static <T> void registerWithScreen(Class<T> clazz, ConfigSettings<T> spec, String modIdForScreen, String screenName, Runnable onScreenSave) {
        ConfigRegistry.register(clazz, spec);
        if (CristelLibExpectPlatform.isClient() && Util.isClothConfigLoaded()) {
            ClientConfigRegistry.registerScreen(modIdForScreen, screenName, onScreenSave, clazz);
        }
    }

    public static <T> T get(Class<T> clazz) {
        ConfigHolder<?> holder = CONFIGS.get(clazz);
        if (holder == null) {
            throw new IllegalStateException("No config registered for: " + clazz.getName());
        }
        return (T)holder.getInstance();
    }

    public static <T> ConfigSettings<T> getSettings(Class<T> clazz) {
        return ConfigRegistry.holder(clazz).getSettings();
    }

    public static <T> ConfigHolder<T> holder(Class<T> clazz) {
        return CONFIGS.get(clazz);
    }

    public static <T> void updateAndSave(T newInstance) {
        ConfigHolder<?> holder = CONFIGS.get(newInstance.getClass());
        if (holder == null) {
            throw new IllegalStateException("No config registered for: " + newInstance.getClass().getName());
        }
        holder.updateAndSave(newInstance);
    }

    public static <T> Class<T> getClazzFromCodec(Codec<T> codec) {
        for (Map.Entry<Class<?>, ConfigHolder<?>> entry : CONFIGS.entrySet()) {
            if (!entry.getValue().getSettings().getCodec().equals(codec)) continue;
            return entry.getKey();
        }
        return null;
    }
}

