/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.neoforge;

import de.cristelknight.cristellib.CristelLib;
import java.util.Optional;
import javax.annotation.Nullable;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModLoadingUtilImpl {
    public static boolean isModLoaded(String modID) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modID);
        }
        return ModLoadingUtilImpl.isModPreLoaded(modID);
    }

    public static boolean isModPreLoaded(String modID) {
        return ModLoadingUtilImpl.getPreLoadedModInfo(modID) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modID) {
        for (ModInfo info : FMLLoader.getCurrent().getLoadingModList().getMods()) {
            if (!info.getModId().equals(modID)) continue;
            return info;
        }
        return null;
    }

    public static Optional<Integer> compare(String modID, String version) {
        if (ModLoadingUtilImpl.isModLoaded(modID)) {
            ModList modList = ModList.get();
            ArtifactVersion modVersion = modList != null ? ((ModContainer)modList.getModContainerById(modID).get()).getModInfo().getVersion() : ModLoadingUtilImpl.getPreLoadedModVersion(modID);
            DefaultArtifactVersion min = new DefaultArtifactVersion(version);
            return Optional.of(modVersion.compareTo((Object)min));
        }
        return Optional.empty();
    }

    public static ArtifactVersion getPreLoadedModVersion(String modID) {
        ModInfo info = ModLoadingUtilImpl.getPreLoadedModInfo(modID);
        if (info == null) {
            throw new RuntimeException(CristelLib.getWithPrefix("Couldn't find mod: " + modID));
        }
        return info.getVersion();
    }
}

