/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.fences;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Fences {
    public static final String modid = "mcwfences";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties wood = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
        Fences.setRegistrationWoodModLoaded(set, block, item, wood);
    }

    public static void setRegistrationHedges(List<String> leaves, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties leave = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES);
        Fences.setRegistrationHedgesModLoaded(leaves, block, item, leave);
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties stone = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE);
        Fences.setRegistrationRockModLoaded(rock, block, item, stone);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("FenceBlock")) {
                    CreateBlockReferences.createBlock(id, registryName -> new FenceBlock(WOOD), block, item);
                    continue;
                }
                if (blockId.reflectedLocation().contains("FenceGateBlock")) {
                    CreateBlockReferences.createBlock(id, registryName -> new FenceGateBlock(Optional.of(WoodType.OAK), WOOD, Optional.of(SoundEvents.FENCE_GATE_CLOSE), Optional.of(SoundEvents.FENCE_GATE_OPEN)), block, item);
                    continue;
                }
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new FenceBlock(WOOD), block, item);
            }
        }
    }

    public static void setRegistrationHedgesModLoaded(List<String> leaves, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties HEDGES = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : leaves) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_LEAVE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), HEDGES), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new FenceBlock(HEDGES), block, item);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.FENCES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("FenceBlock")) {
                    CreateBlockReferences.createBlockStone(id, registryName -> new FenceBlock(STONE), block, item);
                    continue;
                }
                if (blockId.reflectedLocation().contains("FenceGateBlock")) {
                    CreateBlockReferences.createBlockStone(id, registryName -> new FenceGateBlock(Optional.of(WoodType.OAK), STONE, Optional.of(SoundEvents.FENCE_GATE_CLOSE), Optional.of(SoundEvents.FENCE_GATE_OPEN)), block, item);
                    continue;
                }
                if (isModLoaded) {
                    CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, registryName -> new FenceBlock(STONE), block, item);
            }
        }
    }
}

