/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

class Doors
extends AbstractType {
    private static final String id = "mcwdoors";

    public Doors(HolderLookup.Provider registries, RecipeOutput output, String modid, String originalMod) {
        super(registries, output, modid, originalMod, id);
    }

    private void door_variant(RecipeOutput consumer, Block door_var, Block planks, Item print) {
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"A", "B", "A"}, (ItemLike)door_var, 1, (ItemLike)planks, (ItemLike)print, Objects.requireNonNull(print.toString()).replace("print_", ""));
    }

    private void other_door(RecipeOutput consumer, String mat, Block log, Block planks, Block slab) {
        Block bark_glass_door = Finder.findBlock(this.modid, mat + "_bark_glass_door");
        Block barn_door = Finder.findBlock(this.modid, mat + "_barn_door");
        Block barn_glass_door = Finder.findBlock(this.modid, mat + "_barn_glass_door");
        Block glass_door = Finder.findBlock(this.modid, mat + "_glass_door");
        Block japanese_door = Finder.findBlock(this.modid, mat + "_japanese_door");
        Block japanese2_door = Finder.findBlock(this.modid, mat + "_japanese2_door");
        Block modern_door = Finder.findBlock(this.modid, mat + "_modern_door");
        Block stable_door = Finder.findBlock(this.modid, mat + "_stable_door");
        Block stable_head_door = Finder.findBlock(this.modid, mat + "_stable_head_door");
        Block western_door = Finder.findBlock(this.modid, mat + "_western_door");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"  A", "ABA", "AAA"}, (ItemLike)western_door, 3, (ItemLike)planks, (ItemLike)slab, "western");
        this.mcwRecipes.mkRpShapelessW1Item(consumer, (ItemLike)planks, (ItemLike)stable_head_door, 1, (ItemLike)stable_door, "stable_head");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"BB", "AA", "AA"}, (ItemLike)stable_door, 3, (ItemLike)planks, (ItemLike)Blocks.IRON_BARS, "stable");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"AB", "AA", "AB"}, (ItemLike)modern_door, 3, (ItemLike)planks, (ItemLike)Blocks.GLASS_PANE, "modern");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)slab, new String[]{"BB", "BB", "AA"}, (ItemLike)japanese2_door, 3, (ItemLike)slab, (ItemLike)Items.PAPER, "shoji_two");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"BB", "BB", "AA"}, (ItemLike)japanese_door, 3, (ItemLike)planks, (ItemLike)Items.PAPER, "shoji");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"AB", "BB", "AB"}, (ItemLike)bark_glass_door, 3, (ItemLike)log, (ItemLike)Blocks.GLASS, "bark");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"AB", "BB", "AB"}, (ItemLike)glass_door, 3, (ItemLike)planks, (ItemLike)Blocks.GLASS_PANE, "glassed");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"BB", "AA", "AA"}, (ItemLike)barn_door, 2, (ItemLike)planks, (ItemLike)Items.STICK, "barn");
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)planks, new String[]{"BB", "AA", "AA"}, (ItemLike)barn_glass_door, 3, (ItemLike)planks, (ItemLike)Blocks.GLASS_PANE, "barn_glass");
    }

    @Override
    public void buildWood(RecipeOutput consumer, List<String> MAT, List<McwWoodMat> woodMat) {
        Map<String, String> variants = this.getStringStringMap();
        if (MAT.size() == woodMat.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                Block log = woodMat.get(i).getLog();
                Block planks = woodMat.get(i).getPlanks();
                Block slab = woodMat.get(i).getSlab();
                this.other_door(consumer, MAT.get(i), log, planks, slab);
                for (Map.Entry<String, String> variant : variants.entrySet()) {
                    Item print = Finder.findItem(id, "print_" + variant.getValue());
                    Block door_var = Finder.findBlock(this.modid, MAT.get(i) + "_" + variant.getKey() + "_door");
                    this.door_variant(consumer, door_var, planks, print);
                }
            }
        }
    }

    @Override
    public void buildStone(RecipeOutput consumer, List<String> MAT, List<McwStoneMat> stoneMat) {
    }

    @Override
    public void buildHedge(RecipeOutput consumer, List<String> MAT, List<Block> leave) {
    }

    private Map<String, String> getStringStringMap() {
        HashMap<String, String> variants = new HashMap<String, String>();
        variants.put("bamboo", "bamboo");
        variants.put("beach", "jungle");
        variants.put("classic", "oak");
        variants.put("cottage", "spruce");
        variants.put("four_panel", "dark_oak");
        variants.put("mystic", "mystic");
        variants.put("nether", "nether");
        variants.put("paper", "birch");
        variants.put("swamp", "swamp");
        variants.put("tropical", "acacia");
        variants.put("waffle", "waffle");
        variants.put("whispering", "whispering");
        return variants;
    }
}

