/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.mapping;

import fr.samlegamer.addonslib.mapping.IMappings;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredRegister;

public class MappingMissing {
    protected static void addMissingBlock(DeferredRegister.Blocks blocks, String oldModid, String newModid, String nameMissing, String nameNew) {
        ResourceLocation old = new ResourceLocation(oldModid, nameMissing);
        ResourceLocation remapped = new ResourceLocation(newModid, nameNew);
        blocks.addAlias(old, remapped);
    }

    protected static void addMissingItem(DeferredRegister.Items items, String oldModid, String newModid, String nameMissing, String nameNew) {
        ResourceLocation old = new ResourceLocation(oldModid, nameMissing);
        ResourceLocation remapped = new ResourceLocation(newModid, nameNew);
        items.addAlias(old, remapped);
    }

    public static class Bridges
    implements IMappings {
        protected String oldModid;
        protected String newModid;
        protected List<String> mats;
        protected List<String> mat_rockable;

        public Bridges(String oldModid, String newModid, List<String> mats) {
            this.oldModid = oldModid;
            this.newModid = newModid;
            this.mats = mats;
        }

        public Bridges(String oldModid, String newModid, List<String> mats_wooden, List<String> mat_rockable) {
            this(oldModid, newModid, mats_wooden);
            this.mat_rockable = mat_rockable;
        }

        @Override
        public void missingnoWoodBlock(DeferredRegister.Blocks blocks) {
            for (String i : this.mats) {
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_log_bridge_middle", i + "_log_bridge_middle");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "rope_" + i + "_bridge", "rope_" + i + "_bridge");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bridge_pier", i + "_bridge_pier");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_log_bridge_stair", i + "_log_bridge_stair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_rope_bridge_stair", i + "_rope_bridge_stair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_rail_bridge", i + "_rail_bridge");
            }
        }

        @Override
        public void missingnoWoodItem(DeferredRegister.Items items) {
            for (String i : this.mats) {
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_log_bridge_middle", i + "_log_bridge_middle");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "rope_" + i + "_bridge", "rope_" + i + "_bridge");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bridge_pier", i + "_bridge_pier");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_log_bridge_stair", i + "_log_bridge_stair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_rope_bridge_stair", i + "_rope_bridge_stair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_rail_bridge", i + "_rail_bridge");
            }
        }

        public void missingnoStoneBlock(DeferredRegister.Blocks blocks, boolean balustrade) {
            for (String i : this.mat_rockable) {
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bridge", i + "_bridge");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bridge_pier", i + "_bridge_pier");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bridge_stair", i + "_bridge_stair");
                if (!balustrade) continue;
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "balustrade_" + i + "_bridge", "balustrade_" + i + "_bridge");
            }
        }

        @Override
        @Deprecated
        public void missingnoStoneBlock(DeferredRegister.Blocks blocks) {
            this.missingnoStoneBlock(blocks, false);
        }

        public void missingnoStoneItem(DeferredRegister.Items items, boolean balustrade) {
            for (String i : this.mat_rockable) {
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bridge", i + "_bridge");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bridge_pier", i + "_bridge_pier");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bridge_stair", i + "_bridge_stair");
                if (!balustrade) continue;
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "balustrade_" + i + "_bridge", "balustrade_" + i + "_bridge");
            }
        }

        @Override
        @Deprecated
        public void missingnoStoneItem(DeferredRegister.Items items) {
            this.missingnoStoneItem(items, false);
        }
    }

    public static class Fences
    implements IMappings {
        protected String oldModid;
        protected String newModid;
        protected List<String> mats;
        protected List<String> mat_rockable;
        protected List<String> leaves;
        protected boolean Hedges = false;

        public Fences(String oldModid, String newModid, List<String> mats) {
            this.oldModid = oldModid;
            this.newModid = newModid;
            this.mats = mats;
        }

        public Fences(String oldModid, String newModid, List<String> mats_wooden, List<String> mat_rockable) {
            this(oldModid, newModid, mats_wooden);
            this.mat_rockable = mat_rockable;
        }

        public void leavesAdding(List<String> leaves) {
            this.Hedges = true;
            this.leaves = leaves;
        }

        @Override
        public void missingnoWoodBlock(DeferredRegister.Blocks blocks) {
            for (String i : this.mats) {
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_picket_fence", i + "_picket_fence");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_stockade_fence", i + "_stockade_fence");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_horse_fence", i + "_horse_fence");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_wired_fence", i + "_wired_fence");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_highley_gate", i + "_highley_gate");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_pyramid_gate", i + "_pyramid_gate");
            }
            if (this.Hedges) {
                for (String i : this.leaves) {
                    MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_hedge", i + "_hedge");
                }
            }
        }

        @Override
        public void missingnoWoodItem(DeferredRegister.Items items) {
            for (String i : this.mats) {
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_picket_fence", i + "_picket_fence");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_stockade_fence", i + "_stockade_fence");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_horse_fence", i + "_horse_fence");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_wired_fence", i + "_wired_fence");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_highley_gate", i + "_highley_gate");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_pyramid_gate", i + "_pyramid_gate");
            }
            if (this.Hedges) {
                for (String i : this.leaves) {
                    MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_hedge", i + "_hedge");
                }
            }
        }

        @Override
        public void missingnoStoneBlock(DeferredRegister.Blocks blocks) {
            for (String i : this.mat_rockable) {
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "modern_" + i + "_wall", "modern_" + i + "_wall");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "railing_" + i + "_wall", "railing_" + i + "_wall");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_railing_gate", i + "_railing_gate");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_pillar_wall", i + "_pillar_wall");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_grass_topped_wall", i + "_grass_topped_wall");
            }
        }

        @Override
        public void missingnoStoneItem(DeferredRegister.Items items) {
            for (String i : this.mat_rockable) {
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "modern_" + i + "_wall", "modern_" + i + "_wall");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "railing_" + i + "_wall", "railing_" + i + "_wall");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_railing_gate", i + "_railing_gate");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_pillar_wall", i + "_pillar_wall");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_grass_topped_wall", i + "_grass_topped_wall");
            }
        }
    }

    public static class Roofs
    implements IMappings {
        protected String oldModid;
        protected String newModid;
        protected List<String> mats;
        protected List<String> mat_rockable;
        protected List<String> leaves;

        public Roofs(String oldModid, String newModid, List<String> mats) {
            this.oldModid = oldModid;
            this.newModid = newModid;
            this.mats = mats;
        }

        public Roofs(String oldModid, String newModid, List<String> mats_wooden, List<String> mat_rockable) {
            this(oldModid, newModid, mats_wooden);
            this.mat_rockable = mat_rockable;
        }

        @Override
        public void missingnoWoodBlock(DeferredRegister.Blocks blocks) {
            for (String i : this.mats) {
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_roof", i + "_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_attic_roof", i + "_attic_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_top_roof", i + "_top_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_lower_roof", i + "_lower_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_steep_roof", i + "_steep_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_upper_lower_roof", i + "_upper_lower_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_upper_steep_roof", i + "_upper_steep_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_roof", i + "_planks_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_attic_roof", i + "_planks_attic_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_top_roof", i + "_planks_top_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_lower_roof", i + "_planks_lower_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_steep_roof", i + "_planks_steep_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_upper_lower_roof", i + "_planks_upper_lower_roof");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_planks_upper_steep_roof", i + "_planks_upper_steep_roof");
            }
        }

        @Override
        public void missingnoWoodItem(DeferredRegister.Items items) {
            for (String i : this.mats) {
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_roof", i + "_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_attic_roof", i + "_attic_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_top_roof", i + "_top_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_lower_roof", i + "_lower_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_steep_roof", i + "_steep_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_upper_lower_roof", i + "_upper_lower_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_upper_steep_roof", i + "_upper_steep_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_roof", i + "_planks_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_attic_roof", i + "_planks_attic_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_top_roof", i + "_planks_top_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_lower_roof", i + "_planks_lower_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_steep_roof", i + "_planks_steep_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_upper_lower_roof", i + "_planks_upper_lower_roof");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_planks_upper_steep_roof", i + "_planks_upper_steep_roof");
            }
        }

        @Override
        public void missingnoStoneBlock(DeferredRegister.Blocks blocks) {
        }

        @Override
        public void missingnoStoneItem(DeferredRegister.Items items) {
        }
    }

    public static class Furnitures
    implements IMappings {
        protected String oldModid;
        protected String newModid;
        protected List<String> mats;

        public Furnitures(String oldModid, String newModid, List<String> mats) {
            this.oldModid = oldModid;
            this.newModid = newModid;
            this.mats = mats;
        }

        @Override
        public void missingnoWoodBlock(DeferredRegister.Blocks blocks) {
            for (String i : this.mats) {
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_wardrobe", i + "_wardrobe");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_modern_wardrobe", i + "_modern_wardrobe");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_double_wardrobe", i + "_double_wardrobe");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bookshelf", i + "_bookshelf");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bookshelf_cupboard", i + "_bookshelf_cupboard");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_drawer", i + "_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_double_drawer", i + "_double_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_bookshelf_drawer", i + "_bookshelf_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_lower_bookshelf_drawer", i + "_lower_bookshelf_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_large_drawer", i + "_large_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_lower_triple_drawer", i + "_lower_triple_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_triple_drawer", i + "_triple_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_desk", i + "_desk");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_covered_desk", i + "_covered_desk");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_modern_desk", i + "_modern_desk");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_table", i + "_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_end_table", i + "_end_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_coffee_table", i + "_coffee_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_glass_table", i + "_glass_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_chair", i + "_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_modern_chair", i + "_modern_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_striped_chair", i + "_striped_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_stool_chair", i + "_stool_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_counter", i + "_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_drawer_counter", i + "_drawer_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_double_drawer_counter", i + "_double_drawer_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_cupboard_counter", i + "_cupboard_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_wardrobe", "stripped_" + i + "_wardrobe");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_modern_wardrobe", "stripped_" + i + "_modern_wardrobe");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_double_wardrobe", "stripped_" + i + "_double_wardrobe");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_bookshelf", "stripped_" + i + "_bookshelf");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_bookshelf_cupboard", "stripped_" + i + "_bookshelf_cupboard");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_drawer", "stripped_" + i + "_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_double_drawer", "stripped_" + i + "_double_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_bookshelf_drawer", "stripped_" + i + "_bookshelf_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_lower_bookshelf_drawer", "stripped_" + i + "_lower_bookshelf_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_large_drawer", "stripped_" + i + "_large_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_lower_triple_drawer", "stripped_" + i + "_lower_triple_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_triple_drawer", "stripped_" + i + "_triple_drawer");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_desk", "stripped_" + i + "_desk");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_covered_desk", "stripped_" + i + "_covered_desk");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_modern_desk", "stripped_" + i + "_modern_desk");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_table", "stripped_" + i + "_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_end_table", "stripped_" + i + "_end_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_coffee_table", "stripped_" + i + "_coffee_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_glass_table", "stripped_" + i + "_glass_table");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_chair", "stripped_" + i + "_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_modern_chair", "stripped_" + i + "_modern_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_striped_chair", "stripped_" + i + "_striped_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_stool_chair", "stripped_" + i + "_stool_chair");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_counter", "stripped_" + i + "_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_drawer_counter", "stripped_" + i + "_drawer_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_double_drawer_counter", "stripped_" + i + "_double_drawer_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_cupboard_counter", "stripped_" + i + "_cupboard_counter");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_kitchen_cabinet", i + "_kitchen_cabinet");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_double_kitchen_cabinet", i + "_double_kitchen_cabinet");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, i + "_glass_kitchen_cabinet", i + "_glass_kitchen_cabinet");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_kitchen_cabinet", "stripped_" + i + "_kitchen_cabinet");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_double_kitchen_cabinet", "stripped_" + i + "_double_kitchen_cabinet");
                MappingMissing.addMissingBlock(blocks, this.oldModid, this.newModid, "stripped_" + i + "_glass_kitchen_cabinet", "stripped_" + i + "_glass_kitchen_cabinet");
            }
        }

        @Override
        public void missingnoWoodItem(DeferredRegister.Items items) {
            for (String i : this.mats) {
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_wardrobe", i + "_wardrobe");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_modern_wardrobe", i + "_modern_wardrobe");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_double_wardrobe", i + "_double_wardrobe");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bookshelf", i + "_bookshelf");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bookshelf_cupboard", i + "_bookshelf_cupboard");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_drawer", i + "_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_double_drawer", i + "_double_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_bookshelf_drawer", i + "_bookshelf_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_lower_bookshelf_drawer", i + "_lower_bookshelf_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_large_drawer", i + "_large_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_lower_triple_drawer", i + "_lower_triple_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_triple_drawer", i + "_triple_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_desk", i + "_desk");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_covered_desk", i + "_covered_desk");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_modern_desk", i + "_modern_desk");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_table", i + "_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_end_table", i + "_end_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_coffee_table", i + "_coffee_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_glass_table", i + "_glass_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_chair", i + "_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_modern_chair", i + "_modern_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_striped_chair", i + "_striped_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_stool_chair", i + "_stool_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_counter", i + "_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_drawer_counter", i + "_drawer_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_double_drawer_counter", i + "_double_drawer_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_cupboard_counter", i + "_cupboard_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_wardrobe", "stripped_" + i + "_wardrobe");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_modern_wardrobe", "stripped_" + i + "_modern_wardrobe");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_double_wardrobe", "stripped_" + i + "_double_wardrobe");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_bookshelf", "stripped_" + i + "_bookshelf");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_bookshelf_cupboard", "stripped_" + i + "_bookshelf_cupboard");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_drawer", "stripped_" + i + "_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_double_drawer", "stripped_" + i + "_double_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_bookshelf_drawer", "stripped_" + i + "_bookshelf_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_lower_bookshelf_drawer", "stripped_" + i + "_lower_bookshelf_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_large_drawer", "stripped_" + i + "_large_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_lower_triple_drawer", "stripped_" + i + "_lower_triple_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_triple_drawer", "stripped_" + i + "_triple_drawer");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_desk", "stripped_" + i + "_desk");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_covered_desk", "stripped_" + i + "_covered_desk");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_modern_desk", "stripped_" + i + "_modern_desk");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_table", "stripped_" + i + "_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_end_table", "stripped_" + i + "_end_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_coffee_table", "stripped_" + i + "_coffee_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_glass_table", "stripped_" + i + "_glass_table");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_chair", "stripped_" + i + "_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_modern_chair", "stripped_" + i + "_modern_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_striped_chair", "stripped_" + i + "_striped_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_stool_chair", "stripped_" + i + "_stool_chair");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_counter", "stripped_" + i + "_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_drawer_counter", "stripped_" + i + "_drawer_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_double_drawer_counter", "stripped_" + i + "_double_drawer_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_cupboard_counter", "stripped_" + i + "_cupboard_counter");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_kitchen_cabinet", i + "_kitchen_cabinet");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_double_kitchen_cabinet", i + "_double_kitchen_cabinet");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, i + "_glass_kitchen_cabinet", i + "_glass_kitchen_cabinet");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_kitchen_cabinet", "stripped_" + i + "_kitchen_cabinet");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_double_kitchen_cabinet", "stripped_" + i + "_double_kitchen_cabinet");
                MappingMissing.addMissingItem(items, this.oldModid, this.newModid, "stripped_" + i + "_glass_kitchen_cabinet", "stripped_" + i + "_glass_kitchen_cabinet");
            }
        }

        @Override
        public void missingnoStoneBlock(DeferredRegister.Blocks blocks) {
        }

        @Override
        public void missingnoStoneItem(DeferredRegister.Items items) {
        }
    }
}

