/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.roofs;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Roofs {
    private static final BlockBehaviour.Properties wood = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS);
    private static final BlockBehaviour.Properties stone = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CUT_SANDSTONE);
    public static final String modid = "mcwroofs";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        Roofs.setRegistrationWoodModLoaded(set, block, item, wood);
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        Roofs.setRegistrationRockModLoaded(rock, block, item, stone);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep") || blockId.reflectedLocation().contains("BaseRoof")) {
                        CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName)), Blocks.OAK_PLANKS.defaultBlockState()), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new Block(WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep") || blockId.reflectedLocation().contains("BaseRoof")) {
                        CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName)), Blocks.COBBLESTONE.defaultBlockState()), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, registryName -> new Block(STONE.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
            }
        }
    }
}

