/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.Bridges;
import fr.samlegamer.addonslib.generation.recipes.Doors;
import fr.samlegamer.addonslib.generation.recipes.Fences;
import fr.samlegamer.addonslib.generation.recipes.Furnitures;
import fr.samlegamer.addonslib.generation.recipes.Paths;
import fr.samlegamer.addonslib.generation.recipes.Roofs;
import fr.samlegamer.addonslib.generation.recipes.Stairs;
import fr.samlegamer.addonslib.generation.recipes.Trapdoors;
import fr.samlegamer.addonslib.generation.recipes.Windows;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_3981;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_8790;

public class McwRecipes
extends FabricRecipeProvider {
    private final String modid;
    private final String mcwModid;
    private final String originalMod;
    private static FabricDataOutput dataGen;
    private static CompletableFuture<class_7225.class_7874> reFu;

    public McwRecipes(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture, String modid, String mcwModid, String originalMod) {
        super(output, registriesFuture);
        this.modid = modid;
        this.mcwModid = mcwModid;
        this.originalMod = originalMod;
        dataGen = output;
        reFu = registriesFuture;
    }

    private static AbstractType getFromModType(ModType modType, String modid, String originalMod) {
        return switch (modType) {
            case ModType.BRIDGES -> new Bridges(dataGen, reFu, modid, originalMod);
            case ModType.DOORS -> new Doors(dataGen, reFu, modid, originalMod);
            case ModType.FENCES -> new Fences(dataGen, reFu, modid, originalMod);
            case ModType.FURNITURES -> new Furnitures(dataGen, reFu, modid, originalMod);
            case ModType.PATHS -> new Paths(dataGen, reFu, modid, originalMod);
            case ModType.ROOFS -> new Roofs(dataGen, reFu, modid, originalMod);
            case ModType.STAIRS -> new Stairs(dataGen, reFu, modid, originalMod);
            case ModType.TRAPDOORS -> new Trapdoors(dataGen, reFu, modid, originalMod);
            case ModType.WINDOWS -> new Windows(dataGen, reFu, modid, originalMod);
            default -> null;
        };
    }

    public static void onRegisterMcwWood(ModType modType, class_2446 generator, class_8790 exporter, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        AbstractType abstractType = McwRecipes.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildWood(generator, exporter, MAT, woodMats);
        }
    }

    public static void onRegisterMcwStone(ModType modType, class_2446 generator, class_8790 exporter, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        AbstractType abstractType = McwRecipes.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildStone(generator, exporter, MAT, stoneMats);
        }
    }

    public static void registerAllMcwWood(class_2446 generator, class_8790 exporter, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        McwRecipes.onRegisterMcwWood(ModType.BRIDGES, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.DOORS, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.FENCES, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.FURNITURES, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.PATHS, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.ROOFS, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.STAIRS, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.TRAPDOORS, generator, exporter, modid, originalMod, MAT, woodMats);
        McwRecipes.onRegisterMcwWood(ModType.WINDOWS, generator, exporter, modid, originalMod, MAT, woodMats);
    }

    public static void registerAllMcwStone(class_2446 generator, class_8790 exporter, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        McwRecipes.onRegisterMcwStone(ModType.BRIDGES, generator, exporter, modid, originalMod, MAT, stoneMats);
        McwRecipes.onRegisterMcwStone(ModType.ROOFS, generator, exporter, modid, originalMod, MAT, stoneMats);
        McwRecipes.onRegisterMcwStone(ModType.FENCES, generator, exporter, modid, originalMod, MAT, stoneMats);
    }

    public static void registerMcwHedge(class_2446 generator, class_8790 exporter, String modid, String originalMod, List<String> MAT, List<class_2248> leave) {
        AbstractType abstractType = McwRecipes.getFromModType(ModType.FENCES, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildHedge(generator, exporter, MAT, leave);
        }
    }

    protected void mkScW1Item(class_2446 generator, class_8790 exporter, class_1935 result, class_1935 firstItem) {
        String recipeId = Objects.requireNonNull(result.method_8389().toString()) + "_stonecutter";
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_3981 builder = class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{firstItem}), (class_7800)class_7800.field_40634, (class_1935)result).method_17970(class_2446.method_32807((class_1935)firstItem), generator.method_10426(firstItem));
        builder.method_36443(recipeExporter, recipeId);
    }

    protected void mkRpW4Items(class_2446 generator, class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, class_1935 thirdItem, class_1935 fourItem, String group) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)) : class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpW3Items(class_2446 generator, class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, class_1935 thirdItem, String group) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)) : class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpW2Items(class_2446 generator, class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, String group) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)) : class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpW1Item(class_2446 generator, class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, String group, String suffix) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = class_2447.method_10436((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(class_2446.method_32807((class_1935)planks), generator.method_10426(planks));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpShapelessW1Item(class_2446 generator, class_8790 exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, int required, String group, String suffix) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2450 shapelessRecipeJsonBuilder = class_2450.method_10448((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10449(firstItem, required).method_10452(group).method_10442(class_2446.method_32807((class_1935)planks), generator.method_10426(planks));
        shapelessRecipeJsonBuilder.method_36443(recipeExporter, result.method_8389().toString() + suffix);
    }

    protected void mkRpShapelessW1Item(class_2446 generator, class_8790 exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, int require, String group) {
        class_8790 recipeExporter = this.withConditions(exporter, new ResourceCondition[]{ResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2450 shapelessRecipeJsonBuilder = class_2450.method_10448((class_7871)generator.field_53722, (class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10449(firstItem, require).method_10452(group).method_10442(class_2446.method_32807((class_1935)planks), generator.method_10426(planks));
        shapelessRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpShapelessW1Item(class_2446 generator, class_8790 exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, String group) {
        this.mkRpShapelessW1Item(generator, exporter, planks, result, count, firstItem, 1, group);
    }

    protected void mkRpShapelessW1Item(class_2446 generator, class_8790 exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, String group, String suffix) {
        this.mkRpShapelessW1Item(generator, exporter, planks, result, count, firstItem, 1, group, suffix);
    }

    protected void mkRpW1Item(class_2446 generator, class_8790 exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, String group) {
        this.mkRpW1Item(generator, exporter, planks, pattern, result, count, firstItem, group, "");
    }

    public String method_10321() {
        return this.modid + " Recipe Generator";
    }

    protected class_2446 method_62766(class_7225.class_7874 registryLookup, class_8790 exporter) {
        return null;
    }
}

