/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.stairs;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class Stairs {
    public static final String modid = "mcwstairs";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        BlockBehaviour.Properties WOOD = BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.WOOD);
        Stairs.setRegistrationWoodModLoaded(set, block, item, WOOD);
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        BlockBehaviour.Properties STONE = BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.STONE).requiresCorrectToolForDrops();
        Stairs.setRegistrationRockModLoaded(set, block, item, STONE);
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.STAIRS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE.setId(block.key(id))), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, () -> new Block(STONE.setId(block.key(id))), block, item);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.STAIRS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD.setId(block.key(id))), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD.setId(block.key(id))), block, item);
            }
        }
    }
}

