/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.stairs;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Stairs {
    public static final String modid = "mcwstairs";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties WOOD = BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.WOOD);
        Stairs.setRegistrationWoodModLoaded(set, block, item, WOOD);
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties STONE = BlockBehaviour.Properties.of().strength(2.0f, 2.3f).sound(SoundType.STONE).requiresCorrectToolForDrops();
        Stairs.setRegistrationRockModLoaded(set, block, item, STONE);
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.STAIRS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlockStone(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), STONE.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, registryName -> new Block(STONE.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.STAIRS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new Block(WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
            }
        }
    }
}

