/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

class Bridges
extends AbstractType {
    private static final String id = "mcwbridges";

    public Bridges(PackOutput packOutput, String modid, String originalMod) {
        super(packOutput, modid, originalMod, id);
    }

    private void pier(RecipeOutput consumer, Block pier, Block log, Block fence) {
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"ABA"}, (ItemLike)pier, 3, (ItemLike)log, (ItemLike)fence, "wooden_piers");
    }

    private void log_bridge(RecipeOutput consumer, Block log_bridge, Block log, Block slab, Block fence) {
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"B B", "AAA"}, (ItemLike)log_bridge, 4, (ItemLike)slab, (ItemLike)fence, "log_bridges");
    }

    private void log_bridge_stair(RecipeOutput consumer, Block log_bridge_stair, Block log, Block log_bridge) {
        this.mcwRecipes.mkRpW1Item(consumer, (ItemLike)log, new String[]{"  A", " AA", "AAA"}, (ItemLike)log_bridge_stair, 6, (ItemLike)log_bridge, "log_stairs");
        this.mcwRecipes.mkRpShapelessW1Item(consumer, (ItemLike)log, (ItemLike)log_bridge, 1, (ItemLike)log_bridge_stair, "recyclable_bridges", "_recycle");
    }

    private void rail_bridge(RecipeOutput consumer, Block rail_bridge, Block log, Block slab, Block fence) {
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"B B", "BAB"}, (ItemLike)rail_bridge, 4, (ItemLike)slab, (ItemLike)fence, "rail_bridges");
    }

    private void rope_bridge_stair(RecipeOutput consumer, Block rope_bridge_stair, Block log, Block rope_bridge) {
        this.mcwRecipes.mkRpW1Item(consumer, (ItemLike)log, new String[]{"  A", " AA", "AAA"}, (ItemLike)rope_bridge_stair, 6, (ItemLike)rope_bridge, "rope_stairs");
        this.mcwRecipes.mkRpShapelessW1Item(consumer, (ItemLike)log, (ItemLike)rope_bridge, 1, (ItemLike)rope_bridge_stair, "recyclable_bridges", "_recycle");
    }

    private void rope_bridge(RecipeOutput consumer, Block rope_bridge, Block log, Block slab) {
        this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)log, new String[]{"B B", "AAA"}, (ItemLike)rope_bridge, 4, (ItemLike)slab, (ItemLike)Items.f_42401_, "rope_bridges");
    }

    @Override
    public void buildWood(RecipeOutput consumer, List<String> MAT, List<McwWoodMat> woodMat) {
        if (MAT.size() == woodMat.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                Block log = woodMat.get(i).getLog();
                Block fence = woodMat.get(i).getFence();
                Block slab = woodMat.get(i).getSlab();
                Block log_bridge = Finder.findBlock(this.modid, MAT.get(i) + "_log_bridge_middle");
                Block rope_bridge = Finder.findBlock(this.modid, "rope_" + MAT.get(i) + "_bridge");
                Block pier_bridge = Finder.findBlock(this.modid, MAT.get(i) + "_bridge_pier");
                Block log_bridge_stair = Finder.findBlock(this.modid, MAT.get(i) + "_log_bridge_stair");
                Block rope_bridge_stair = Finder.findBlock(this.modid, MAT.get(i) + "_rope_bridge_stair");
                Block rail_bridge = Finder.findBlock(this.modid, MAT.get(i) + "_rail_bridge");
                this.pier(consumer, pier_bridge, log, fence);
                this.log_bridge(consumer, log_bridge, log, slab, fence);
                this.log_bridge_stair(consumer, log_bridge_stair, log, log_bridge);
                this.rope_bridge(consumer, rope_bridge, log, slab);
                this.rope_bridge_stair(consumer, rope_bridge_stair, log, rope_bridge);
                this.rail_bridge(consumer, rail_bridge, log, slab, fence);
            }
        }
    }

    @Override
    public void buildStone(RecipeOutput consumer, List<String> MAT, List<McwStoneMat> stoneMat) {
        if (MAT.size() == stoneMat.size()) {
            for (int i = 0; i < MAT.size(); ++i) {
                Block stoneB = stoneMat.get(i).getStoneBase();
                Block wall = stoneMat.get(i).getWall();
                Block slab = stoneMat.get(i).getSlab();
                Block stone_bridge = Finder.findBlock(this.modid, MAT.get(i) + "_bridge");
                Block stone_pier_bridge = Finder.findBlock(this.modid, MAT.get(i) + "_bridge_pier");
                Block stone_bridge_stair = Finder.findBlock(this.modid, MAT.get(i) + "_bridge_stair");
                Block balustrade_stone_bridge = Finder.findBlock(this.modid, "balustrade_" + MAT.get(i) + "_bridge");
                this.pier(consumer, stone_pier_bridge, stoneB, wall);
                this.log_bridge(consumer, stone_bridge, stoneB, slab, wall);
                this.log_bridge_stair(consumer, stone_bridge_stair, stoneB, stone_bridge);
                this.mcwRecipes.mkRpW2Items(consumer, (ItemLike)stoneB, new String[]{"BBB", "AAA"}, (ItemLike)balustrade_stone_bridge, 5, (ItemLike)slab, (ItemLike)wall, "balustrade_bridges");
            }
        }
    }

    @Override
    public void buildHedge(RecipeOutput consumer, List<String> MAT, List<Block> leave) {
    }
}

