/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.tags;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

public abstract class McwBlockTags
extends BlockTagsProvider {
    public McwBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, modId, existingFileHelper);
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> STONE, List<String> LEAVE) {
        this.mcwWindowsTags(modid, WOOD);
        this.mcwStairsTags(modid, WOOD);
        this.mcwRoofsTags(modid, WOOD, STONE);
        this.mcwPathsTags(modid, WOOD);
        this.mcwFurnituresTags(modid, WOOD);
        this.mcwFencesTags(modid, WOOD, LEAVE, STONE);
        this.mcwBridgesTagsWood(modid, WOOD);
        this.mcwDoorsTagsWood(modid, WOOD);
        this.mcwTrapdoorsTagsWood(modid, WOOD);
        if (!STONE.isEmpty()) {
            this.mcwBridgesTagsStone(modid, STONE);
        }
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> LEAVE) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>(), LEAVE);
    }

    public void addAllMcwTags(String modid, List<String> WOOD) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>());
    }

    public void mcwWindowsTags(String modid, List<String> WOOD) {
        HashSet<Block> blocksWood = new HashSet<Block>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.WINDOWS_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        this.m_206424_(BlockTags.f_13032_).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_window2")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_window"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "blinds")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_blinds"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "curtain_rods")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_curtain_rod"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "parapets")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_log_parapet"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "shutters")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_shutter"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "windows_four")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_four_window"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "windows_two")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_window2"));
        this.m_206424_(McwBlockTags.getTag("mcwwindows", "windows")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_window"));
    }

    public void mcwStairsTags(String modid, List<String> WOOD) {
        HashSet<Block> blocksWood = new HashSet<Block>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.STAIRS_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "balconies")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_balcony"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "bulk_stairs")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_bulk_stairs"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "compact_stairs")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_compact_stairs"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "loft_stairs")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_loft_stairs"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "platforms")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_platform"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "railings")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_railing"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "skyline_stairs")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_skyline_stairs"));
        this.m_206424_(McwBlockTags.getTag("mcwstairs", "terrace_stairs")).m_255179_((Object[])this.getSetWithEndsWith(blocksWood, "_terrace_stairs"));
    }

    public void mcwRoofsTags(String modid, List<String> WOOD, List<String> STONE) {
        HashSet<Block> blocksWood = new HashSet<Block>();
        HashSet<Block> blocksStone = new HashSet<Block>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.ROOFS_WOOD_BLOCKS);
        this.addBlocks(modid, STONE, blocksStone, McwBlocksIdBase.ROOFS_STONE_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])this.listToArray(blocksStone.stream().toList()));
    }

    public void mcwPathsTags(String modid, List<String> WOOD) {
        ArrayList<Block> blocksWood = new ArrayList<Block>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.PATHS_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        this.m_206424_(McwBlockTags.getTag("mcwpaths", "wooden_paths")).m_255179_((Object[])this.listToArray(blocksWood));
    }

    public void mcwFurnituresTags(String modid, List<String> WOOD) {
        HashSet<Block> blocksWood = new HashSet<Block>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.FURNITURES_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bookshelf_cupboard", Collections.singletonList("_bookshelf_cupboard"));
        map.put("bookshelf_drawer", Collections.singletonList("_bookshelf_drawer"));
        map.put("bookshelf", Collections.singletonList("_bookshelf"));
        map.put("cabinet", Arrays.asList("_kitchen_cabinet", "_double_kitchen_cabinet", "_glass_kitchen_cabinet"));
        map.put("chair", Collections.singletonList("_chair"));
        map.put("coffee_table", Collections.singletonList("_coffee_table"));
        map.put("counter", Collections.singletonList("_counter"));
        map.put("covered_desk", Collections.singletonList("_covered_desk"));
        map.put("cupboard_counter", Collections.singletonList("_cupboard_counter"));
        map.put("desk", Collections.singletonList("_desk"));
        map.put("double_drawer_counter", Collections.singletonList("_double_drawer_counter"));
        map.put("double_drawer", Collections.singletonList("_double_drawer"));
        map.put("double_wardrobe", Collections.singletonList("_double_wardrobe"));
        map.put("drawer", Collections.singletonList("_drawer"));
        map.put("end_table", Collections.singletonList("_end_table"));
        map.put("glass_table", Collections.singletonList("_glass_table"));
        map.put("large_drawer", Collections.singletonList("_large_drawer"));
        map.put("lower_bookshelf_drawer", Collections.singletonList("_lower_bookshelf_drawer"));
        map.put("lower_triple_drawer", Collections.singletonList("_lower_triple_drawer"));
        map.put("modern_chair", Collections.singletonList("_modern_chair"));
        map.put("modern_desk", Collections.singletonList("_modern_desk"));
        map.put("modern_wardrobe", Collections.singletonList("_modern_wardrobe"));
        map.put("stool_chair", Collections.singletonList("_stool_chair"));
        map.put("striped_chair", Collections.singletonList("_striped_chair"));
        map.put("table", Collections.singletonList("_table"));
        map.put("triple_drawer", Collections.singletonList("_triple_drawer"));
        map.put("wadrobe", Collections.singletonList("_wardrobe"));
        map.put("kitchen_sink", Collections.singletonList("_kitchen_sink"));
        for (Map.Entry mapEntry : map.entrySet()) {
            List list = (List)mapEntry.getValue();
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (String mat : WOOD) {
                for (String i : list) {
                    blocks.add(Finder.findBlock(modid, mat + i));
                    blocks.add(Finder.findBlock(modid, "stripped_" + mat + i));
                }
            }
            this.m_206424_(McwBlockTags.getTag("mcwfurnitures", (String)mapEntry.getKey())).m_255179_((Object[])this.listToArray(blocks));
        }
    }

    public void mcwFencesTags(String modid, List<String> WOOD, List<String> LEAVE, List<String> STONE) {
        HashSet<Block> blocksWood = new HashSet<Block>();
        ArrayList<Block> blocksLeave = new ArrayList<Block>();
        HashSet<Block> blocksStone = new HashSet<Block>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.FENCES_WOOD_BLOCKS);
        this.addBlocks(modid, LEAVE, blocksLeave, McwBlocksIdBase.FENCES_LEAVE_BLOCKS);
        this.addBlocks(modid, STONE, blocksStone, McwBlocksIdBase.FENCES_STONE_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])this.listToArray(blocksStone.stream().toList()));
        this.m_206424_(BlockTags.f_144281_).m_255179_((Object[])this.listToArray(blocksLeave.stream().toList()));
        Object[] picket_fences = this.getSetWithContain(blocksWood, "picket_fence");
        Object[] stockade_fences = this.getSetWithContain(blocksWood, "stockade_fence");
        Object[] horse_fences = this.getSetWithContain(blocksWood, "horse_fence");
        Object[] wired_fences = this.getSetWithContain(blocksWood, "wired_fence");
        Object[] highley_gates = this.getSetWithContain(blocksWood, "highley_gate");
        Object[] pyramid_gates = this.getSetWithContain(blocksWood, "pyramid_gate");
        Object[] curved_gates = this.getSetWithContain(blocksWood, "curved_gate");
        Object[] hedges = this.listToArray(blocksLeave);
        Object[] modern_wall = this.getSetWithStartsWith(blocksStone, "modern_");
        Object[] railing_wall = this.getSetWithStartsWith(blocksStone, "railing_");
        Object[] railing_gate = this.getSetWithEndsWith(blocksStone, "_railing_gate");
        Object[] pillar_wall = this.getSetWithEndsWith(blocksStone, "_pillar_wall");
        Object[] grass_topped_wall = this.getSetWithEndsWith(blocksStone, "_grass_topped_wall");
        this.m_206424_(BlockTags.f_13055_).m_255179_(highley_gates).m_255179_(pyramid_gates).m_255179_(curved_gates).m_255179_(railing_gate);
        this.m_206424_(BlockTags.f_13039_).m_255179_(hedges).m_255179_(modern_wall).m_255179_(pillar_wall).m_255179_(railing_wall).m_255179_(grass_topped_wall).m_255179_(picket_fences).m_255179_(stockade_fences).m_255179_(horse_fences).m_255179_(wired_fences).m_255179_(curved_gates);
        this.m_206424_(BlockTags.f_13032_).m_255179_(hedges).m_255179_(grass_topped_wall);
        this.m_206424_(BlockTags.f_13098_).m_255179_(picket_fences).m_255179_(stockade_fences).m_255179_(horse_fences).m_255179_(wired_fences).m_255179_(curved_gates);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "curved_double_gates")).m_255179_(curved_gates);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "highley_gates")).m_255179_(highley_gates);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "horse_fences")).m_255179_(horse_fences);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "picket_fences")).m_255179_(picket_fences);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "pyramid_gates")).m_255179_(pyramid_gates);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "pyramid_gates")).m_255179_(pyramid_gates);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "stockade_fences")).m_255179_(stockade_fences);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "wired_fences")).m_255179_(wired_fences);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "hedges")).m_255179_(hedges);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "grass_topped_walls")).m_255179_(grass_topped_wall);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "modern_walls")).m_255179_(modern_wall);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "pillar_walls")).m_255179_(pillar_wall);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "railing_gates")).m_255179_(railing_gate);
        this.m_206424_(McwBlockTags.getTag("mcwfences", "railing_walls")).m_255179_(railing_wall);
    }

    public void mcwBridgesTagsWood(String modid, List<String> MAT) {
        HashSet<Block> blocksWood = new HashSet<Block>();
        this.addBlocks(modid, MAT, blocksWood, McwBlocksIdBase.BRIDGES_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocksWood.stream().toList()));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "log_bridges")).m_255179_((Object[])this.getSetWithContain(blocksWood, "log_bridge_middle"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "log_stairs")).m_255179_((Object[])this.getSetWithContain(blocksWood, "log_bridge_stair"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "rail_bridges")).m_255179_((Object[])this.getSetWithContain(blocksWood, "rail_bridge"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "rope_bridges")).m_255179_((Object[])this.getSetWithStartsWith(blocksWood, "rope_"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "rope_stairs")).m_255179_((Object[])this.getSetWithContain(blocksWood, "rope_bridge_stair"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "wooden_piers")).m_255179_((Object[])this.getSetWithContain(blocksWood, "bridge_pier"));
    }

    public void mcwBridgesTagsStone(String modid, List<String> MAT) {
        HashSet<Block> blocks = new HashSet<Block>();
        this.addBlocks(modid, MAT, blocks, McwBlocksIdBase.BRIDGES_STONE_BLOCKS);
        this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])this.listToArray(blocks.stream().toList()));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "stone_bridges")).m_255179_((Object[])this.getSetWithEndsWith(blocks, "_bridge"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "stone_piers")).m_255179_((Object[])this.getSetWithContain(blocks, "bridge_pier"));
        this.m_206424_(McwBlockTags.getTag("mcwbridges", "stone_stairs")).m_255179_((Object[])this.getSetWithContain(blocks, "bridge_stair"));
    }

    public void mcwDoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        this.addBlocks(modid, MAT, blocks, McwBlocksIdBase.DOORS_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocks.stream().toList()));
        Object[] blockArray = this.listToArray(blocks);
        this.m_206424_(BlockTags.f_13095_).m_255179_(blockArray);
        HashMap<String, String> moddedTag = new HashMap<String, String>();
        moddedTag.put("bamboo", "bamboo");
        moddedTag.put("barn", "barn");
        moddedTag.put("barn_glass", "barn_glass");
        moddedTag.put("beach", "beach");
        moddedTag.put("classic", "classic");
        moddedTag.put("cottage", "cottage");
        moddedTag.put("four_panel", "four_panel");
        moddedTag.put("glass", "glass");
        moddedTag.put("modern", "modern");
        moddedTag.put("mystic", "mystic");
        moddedTag.put("nether", "nether");
        moddedTag.put("paper", "paper");
        moddedTag.put("shoji", "japanese");
        moddedTag.put("shoji_whole", "japanese2");
        moddedTag.put("stable", "stable");
        moddedTag.put("stable_head", "stable_head");
        moddedTag.put("swamp", "swamp");
        moddedTag.put("tropical", "tropical");
        moddedTag.put("waffle", "waffle");
        moddedTag.put("western", "western");
        moddedTag.put("whispering", "whispering");
        for (Map.Entry map : moddedTag.entrySet()) {
            Object[] blocks2 = new Block[MAT.size()];
            for (String mat : MAT) {
                Block block = Finder.findBlock(modid, mat + "_" + (String)map.getValue() + "_door");
                blocks2[MAT.indexOf((Object)mat)] = block;
            }
            TagKey<Block> tag = McwBlockTags.getTag("mcwdoors", (String)map.getKey() + "_doors");
            this.m_206424_(tag).m_255179_(blocks2);
        }
    }

    public void mcwTrapdoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        this.addBlocks(modid, MAT, blocks, McwBlocksIdBase.TRAPDOORS_WOOD_BLOCKS);
        this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])this.listToArray(blocks.stream().toList()));
        Object[] blockArray = this.listToArray(blocks);
        this.m_206424_(BlockTags.f_13102_).m_255179_(blockArray);
        HashMap<String, String> moddedTag = new HashMap<String, String>();
        moddedTag.put("bamboo", "bamboo");
        moddedTag.put("bark", "bark");
        moddedTag.put("barn", "barn");
        moddedTag.put("barred", "barred");
        moddedTag.put("barrel", "barrel");
        moddedTag.put("beach", "beach");
        moddedTag.put("cottage", "cottage");
        moddedTag.put("four_panel", "four_panel");
        moddedTag.put("glass", "glass");
        moddedTag.put("mystic", "mystic");
        moddedTag.put("paper", "paper");
        moddedTag.put("ranch", "ranch");
        moddedTag.put("swamp", "swamp");
        moddedTag.put("tropical", "tropical");
        moddedTag.put("waffle", "blossom");
        moddedTag.put("whispering", "whispering");
        for (Map.Entry map : moddedTag.entrySet()) {
            Object[] blocks2 = new Block[MAT.size()];
            for (String mat : MAT) {
                Block block = Finder.findBlock(modid, mat + "_" + (String)map.getValue() + "_trapdoor");
                blocks2[MAT.indexOf((Object)mat)] = block;
            }
            TagKey<Block> tag = McwBlockTags.getTag("mcwdoors", (String)map.getKey() + "_trapdoors");
            this.m_206424_(tag).m_255179_(blocks2);
        }
    }

    public static TagKey<Block> getTag(String id, String tagName) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id, (String)tagName));
    }

    private Block[] getSetWithContain(Set<Block> blocks, String contain) {
        ArrayList<Block> finalBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!Finder.getIdOfBlock(block).contains(contain)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private Block[] getSetWithEndsWith(Set<Block> blocks, String endsWith) {
        ArrayList<Block> finalBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!Finder.getIdOfBlock(block).endsWith(endsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private Block[] getSetWithStartsWith(Set<Block> blocks, String startsWith) {
        ArrayList<Block> finalBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!Finder.getIdOfBlock(block).startsWith(startsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private Block[] listToArray(List<Block> finalBlocks) {
        Block[] blockArray = new Block[finalBlocks.size()];
        for (int i = 0; i < finalBlocks.size(); ++i) {
            blockArray[i] = finalBlocks.get(i);
        }
        return blockArray;
    }

    private void addBlocks(String modid, List<String> MAT, Collection<Block> blockSet, McwBlockIdBase blocks) {
        for (String mat : MAT) {
            for (BlockId blockId : blocks.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                Block block = Finder.findBlock(modid, id);
                blockSet.add(block);
            }
        }
    }
}

