/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.Bridges;
import fr.samlegamer.addonslib.generation.recipes.Doors;
import fr.samlegamer.addonslib.generation.recipes.Fences;
import fr.samlegamer.addonslib.generation.recipes.Furnitures;
import fr.samlegamer.addonslib.generation.recipes.Paths;
import fr.samlegamer.addonslib.generation.recipes.Roofs;
import fr.samlegamer.addonslib.generation.recipes.Stairs;
import fr.samlegamer.addonslib.generation.recipes.Trapdoors;
import fr.samlegamer.addonslib.generation.recipes.Windows;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class McwRecipes
extends RecipeProvider {
    private final String modid;
    private final String mcwModid;
    private final String originalMod;

    public McwRecipes(HolderLookup.Provider registries, RecipeOutput output, String modid, String mcwModid, String originalMod) {
        super(registries, output);
        this.modid = modid;
        this.mcwModid = mcwModid;
        this.originalMod = originalMod;
    }

    private AbstractType getFromModType(ModType modType, String modid, String originalMod) {
        return switch (modType) {
            case ModType.BRIDGES -> new Bridges(this.registries, this.output, modid, originalMod);
            case ModType.DOORS -> new Doors(this.registries, this.output, modid, originalMod);
            case ModType.FENCES -> new Fences(this.registries, this.output, modid, originalMod);
            case ModType.FURNITURES -> new Furnitures(this.registries, this.output, modid, originalMod);
            case ModType.PATHS -> new Paths(this.registries, this.output, modid, originalMod);
            case ModType.ROOFS -> new Roofs(this.registries, this.output, modid, originalMod);
            case ModType.STAIRS -> new Stairs(this.registries, this.output, modid, originalMod);
            case ModType.TRAPDOORS -> new Trapdoors(this.registries, this.output, modid, originalMod);
            case ModType.WINDOWS -> new Windows(this.registries, this.output, modid, originalMod);
            default -> null;
        };
    }

    public void onRegisterMcwWood(ModType modType, RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        AbstractType abstractType = this.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildWood(output, MAT, woodMats);
        }
    }

    public void onRegisterMcwStone(ModType modType, RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        AbstractType abstractType = this.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildStone(output, MAT, stoneMats);
        }
    }

    public void registerAllMcwWood(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        this.onRegisterMcwWood(ModType.BRIDGES, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.DOORS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.FENCES, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.FURNITURES, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.PATHS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.ROOFS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.STAIRS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.TRAPDOORS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.WINDOWS, output, modid, originalMod, MAT, woodMats);
    }

    public void registerAllMcwStone(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        this.onRegisterMcwStone(ModType.BRIDGES, output, modid, originalMod, MAT, stoneMats);
        this.onRegisterMcwStone(ModType.ROOFS, output, modid, originalMod, MAT, stoneMats);
        this.onRegisterMcwStone(ModType.FENCES, output, modid, originalMod, MAT, stoneMats);
    }

    public void registerMcwHedge(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<Block> leave) {
        AbstractType abstractType = this.getFromModType(ModType.FENCES, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildHedge(output, MAT, leave);
        }
    }

    protected void mkScW1Item(RecipeOutput output, ItemLike result, ItemLike firstItem) {
        String recipeId = Objects.requireNonNull(result.asItem().toString()) + "_stonecutter";
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)firstItem), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).unlockedBy(McwRecipes.getHasName((ItemLike)firstItem), this.has(firstItem)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}), recipeId);
    }

    protected void mkRpW4Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, ItemLike fourItem, String group) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)) : (pattern.length == 2 ? this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)) : this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
    }

    protected void mkRpW3Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, String group) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)) : (pattern.length == 2 ? this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)) : this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
    }

    protected void mkRpW2Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, String group) {
        ShapedRecipeBuilder shapedRecipeBuilder = pattern.length == 3 ? this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)) : (pattern.length == 2 ? this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)) : this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)));
        shapedRecipeBuilder.save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
    }

    protected void mkRpW1Item(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, String group, String suffix) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}), Objects.requireNonNull(result.asItem().toString()) + suffix);
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group, String suffix) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, result, count).requires(firstItem, required).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}), Objects.requireNonNull(result.asItem().toString()) + suffix);
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group) {
        this.shapeless(RecipeCategory.BUILDING_BLOCKS, result, count).requires(firstItem, required).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, String group) {
        this.mkRpShapelessW1Item(output, planks, result, count, firstItem, 1, group);
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, String group, String suffix) {
        this.mkRpShapelessW1Item(output, planks, result, count, firstItem, 1, group, suffix);
    }

    protected void mkRpW1Item(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, String group) {
        if (pattern.length == 3) {
            this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
        } else if (pattern.length == 2) {
            this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
        } else {
            this.shaped(RecipeCategory.BUILDING_BLOCKS, result, count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), this.has(planks)).save(output.withConditions(new ICondition[]{new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)}));
        }
    }

    protected void buildRecipes() {
    }
}

