/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.tab;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.ModList;

public class NewIconRandom {

    public static class Properties {
        private boolean roofs = false;
        private boolean fences = false;
        private boolean bridges = false;
        private boolean furnitures = false;
        private boolean windows = false;
        private boolean doors = false;
        private boolean trapdoors = false;
        private boolean paths = false;
        private boolean stairs = false;
        private Block roofsIcon;
        private Block fencesIcon;
        private Block furnituresIcon;
        private Block bridgesIcon;
        private Block windowsIcon;
        private Block doorsIcon;
        private Block trapdoorsIcon;
        private Block pathsIcon;
        private Block stairsIcon;
        private int depedencies = 0;

        public Properties(Block roofsIcon, Block fencesIcon, Block furnituresIcon, Block bridgesIcon, Block windowsIcon, Block doorsIcon, Block trapdoorsIcon, Block pathsIcon, Block stairsIcon) {
            this.roofsIcon = roofsIcon;
            this.fencesIcon = fencesIcon;
            this.furnituresIcon = furnituresIcon;
            this.bridgesIcon = bridgesIcon;
            this.windowsIcon = windowsIcon;
            this.doorsIcon = doorsIcon;
            this.trapdoorsIcon = trapdoorsIcon;
            this.pathsIcon = pathsIcon;
            this.stairsIcon = stairsIcon;
        }

        @Deprecated
        public Properties(Block roofsIcon, Block fencesIcon, Block furnituresIcon, Block bridgesIcon, Block windowsIcon, Block doorsIcon, Block trapdoorsIcon, Block pathsIcon) {
            this(roofsIcon, fencesIcon, furnituresIcon, bridgesIcon, windowsIcon, doorsIcon, trapdoorsIcon, pathsIcon, Blocks.CRAFTING_TABLE);
        }

        public Properties(Block roofsIcon, Block fencesIcon, Block bridgesIcon) {
            this.roofsIcon = roofsIcon;
            this.fencesIcon = fencesIcon;
            this.bridgesIcon = bridgesIcon;
        }

        public Properties stairs() {
            this.stairs = true;
            return this;
        }

        public Properties windows() {
            this.windows = true;
            return this;
        }

        public Properties doors() {
            this.doors = true;
            return this;
        }

        public Properties trapdoors() {
            this.trapdoors = true;
            return this;
        }

        public Properties paths() {
            this.paths = true;
            return this;
        }

        public Properties roofs() {
            this.roofs = true;
            return this;
        }

        public Properties fences() {
            this.fences = true;
            return this;
        }

        public Properties bridges() {
            this.bridges = true;
            return this;
        }

        public Properties furnitures() {
            this.furnitures = true;
            return this;
        }

        public Block buildWood() {
            this.loadedBool(this.bridges);
            this.loadedBool(this.fences);
            this.loadedBool(this.roofs);
            this.loadedBool(this.furnitures);
            this.loadedBool(this.paths);
            this.loadedBool(this.trapdoors);
            this.loadedBool(this.doors);
            this.loadedBool(this.windows);
            this.loadedBool(this.stairs);
            if (this.loadedAllWood()) {
                Random rand = new Random();
                int i = rand.nextInt(this.depedencies - 1);
                switch (i) {
                    case 1: {
                        return this.bridgesIcon;
                    }
                    case 2: {
                        return this.fencesIcon;
                    }
                    case 0: {
                        return this.roofsIcon;
                    }
                    case 3: {
                        return this.furnituresIcon;
                    }
                    case 4: {
                        return this.pathsIcon;
                    }
                    case 5: {
                        return this.trapdoorsIcon;
                    }
                    case 6: {
                        return this.doorsIcon;
                    }
                    case 7: {
                        return this.windowsIcon;
                    }
                    case 8: {
                        return this.stairsIcon;
                    }
                }
            } else {
                if (this.loaded("mcwfurnitures")) {
                    return this.furnituresIcon;
                }
                if (this.loaded("mcwbridges")) {
                    return this.bridgesIcon;
                }
                if (this.loaded("mcwfences")) {
                    return this.fencesIcon;
                }
                if (this.loaded("mcwroofs")) {
                    return this.roofsIcon;
                }
                if (this.loaded("mcwpaths")) {
                    return this.pathsIcon;
                }
                if (this.loaded("mcwdoors")) {
                    return this.doorsIcon;
                }
                if (this.loaded("mcwtrpdoors")) {
                    return this.trapdoorsIcon;
                }
                if (this.loaded("mcwwindows")) {
                    return this.windowsIcon;
                }
                if (this.loaded("mcwstairs")) {
                    return this.stairsIcon;
                }
            }
            return Blocks.CRAFTING_TABLE;
        }

        public Block buildStone() {
            this.loadedBool(this.bridges);
            this.loadedBool(this.fences);
            this.loadedBool(this.roofs);
            if (this.loadedAllStone()) {
                Random rand = new Random();
                int i = rand.nextInt(this.depedencies - 1);
                switch (i) {
                    case 1: {
                        return this.bridgesIcon;
                    }
                    case 2: {
                        return this.fencesIcon;
                    }
                    case 0: {
                        return this.roofsIcon;
                    }
                }
            } else {
                if (this.loaded("mcwbridges")) {
                    return this.bridgesIcon;
                }
                if (this.loaded("mcwfences")) {
                    return this.fencesIcon;
                }
                if (this.loaded("mcwroofs")) {
                    return this.roofsIcon;
                }
            }
            return Blocks.CRAFTING_TABLE;
        }

        private void loadedBool(boolean b) {
            if (b) {
                ++this.depedencies;
            }
        }

        private boolean loaded(String modid) {
            return ModList.get().isLoaded(modid);
        }

        private boolean loadedAllStone() {
            return this.loaded("mcwbridges") && this.loaded("mcwfences") && this.loaded("mcwroofs");
        }

        private boolean loadedAllWood() {
            return this.loaded("mcwbridges") && this.loaded("mcwfences") && this.loaded("mcwroofs") && this.loaded("mcwfurnitures") && this.loaded("mcwpaths") && this.loaded("mcwdoors") && this.loaded("mcwtrpdoors") && this.loaded("mcwwindows");
        }
    }

    public static class NewProperties {
        private EnumSet<BlockType> activeTypes = EnumSet.noneOf(BlockType.class);
        private Block roofsIcon;
        private Block fencesIcon;
        private Block furnituresIcon;
        private Block bridgesIcon;
        private Block windowsIcon;
        private Block doorsIcon;
        private Block trapdoorsIcon;
        private Block pathsIcon;
        private Block stairsIcon;
        private int dependencies = 0;
        public Block defaultIcon = Blocks.CRAFTING_TABLE;

        public NewProperties(Block roofsIcon, Block fencesIcon, Block furnituresIcon, Block bridgesIcon, Block windowsIcon, Block doorsIcon, Block trapdoorsIcon, Block pathsIcon, Block stairsIcon) {
            this.roofsIcon = roofsIcon;
            this.fencesIcon = fencesIcon;
            this.furnituresIcon = furnituresIcon;
            this.bridgesIcon = bridgesIcon;
            this.windowsIcon = windowsIcon;
            this.doorsIcon = doorsIcon;
            this.trapdoorsIcon = trapdoorsIcon;
            this.pathsIcon = pathsIcon;
            this.stairsIcon = stairsIcon;
        }

        public NewProperties addType(BlockType type) {
            this.activeTypes.add(type);
            return this;
        }

        public Block buildIcon(BlockType ... types) {
            for (BlockType type : types) {
                if (!this.isTypeLoaded(type)) continue;
                ++this.dependencies;
            }
            if (this.allTypesLoaded(types)) {
                return this.getRandomIcon(types);
            }
            return this.getFallbackIcon(types);
        }

        private Block getRandomIcon(BlockType ... types) {
            Random rand = new Random();
            int i = rand.nextInt(this.dependencies);
            switch (types[i]) {
                case BRIDGES: {
                    return this.bridgesIcon;
                }
                case FENCES: {
                    return this.fencesIcon;
                }
                case ROOFS: {
                    return this.roofsIcon;
                }
                case FURNITURES: {
                    return this.furnituresIcon;
                }
                case PATHS: {
                    return this.pathsIcon;
                }
                case TRAPDOORS: {
                    return this.trapdoorsIcon;
                }
                case DOORS: {
                    return this.doorsIcon;
                }
                case WINDOWS: {
                    return this.windowsIcon;
                }
                case STAIRS: {
                    return this.stairsIcon;
                }
            }
            return this.defaultIcon;
        }

        private boolean isTypeLoaded(BlockType type) {
            String modId = this.getModIdForType(type);
            return ModList.get().isLoaded(modId);
        }

        private boolean allTypesLoaded(BlockType ... types) {
            for (BlockType type : types) {
                if (this.isTypeLoaded(type)) continue;
                return false;
            }
            return true;
        }

        private String getModIdForType(BlockType type) {
            switch (type) {
                case ROOFS: {
                    return "mcwroofs";
                }
                case FENCES: {
                    return "mcwfences";
                }
                case BRIDGES: {
                    return "mcwbridges";
                }
                case FURNITURES: {
                    return "mcwfurnitures";
                }
                case WINDOWS: {
                    return "mcwwindows";
                }
                case DOORS: {
                    return "mcwdoors";
                }
                case TRAPDOORS: {
                    return "mcwtrpdoors";
                }
                case PATHS: {
                    return "mcwpaths";
                }
                case STAIRS: {
                    return "mcwstairs";
                }
            }
            return "";
        }

        private Block getFallbackIcon(BlockType ... types) {
            for (BlockType type : types) {
                if (!this.isTypeLoaded(type)) continue;
                return this.getIconForType(type);
            }
            return this.defaultIcon;
        }

        private Block getIconForType(BlockType type) {
            switch (type) {
                case ROOFS: {
                    return this.roofsIcon;
                }
                case FENCES: {
                    return this.fencesIcon;
                }
                case BRIDGES: {
                    return this.bridgesIcon;
                }
                case FURNITURES: {
                    return this.furnituresIcon;
                }
                case WINDOWS: {
                    return this.windowsIcon;
                }
                case DOORS: {
                    return this.doorsIcon;
                }
                case TRAPDOORS: {
                    return this.trapdoorsIcon;
                }
                case PATHS: {
                    return this.pathsIcon;
                }
                case STAIRS: {
                    return this.stairsIcon;
                }
            }
            return this.defaultIcon;
        }
    }

    public static enum BlockType {
        ROOFS,
        FENCES,
        BRIDGES,
        FURNITURES,
        WINDOWS,
        DOORS,
        TRAPDOORS,
        PATHS,
        STAIRS;

    }
}

