/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.loot_tables;

import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_7225;

public abstract class McwLootTables
extends FabricBlockLootTableProvider {
    private final Set<class_2248> blockSet = new HashSet<class_2248>();

    protected McwLootTables(FabricDataOutput dataGenerator, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataGenerator, registryLookup);
    }

    protected Set<class_2248> getBlockSet() {
        return this.blockSet;
    }

    protected void addBlock(String modid, List<String> MAT, McwBlockIdBase blocks) {
        for (String mat : MAT) {
            for (BlockId id : blocks.blocks()) {
                String blockName = McwBlocksIdBase.replacement(id.id(), mat);
                class_2248 block = Finder.findBlock(modid, blockName);
                if (block != null) {
                    this.blockSet.add(block);
                    continue;
                }
                AddonsLib.LOGGER.info("[McwLootTables] ERROR: Block not found: {}:{}", (Object)modid, (Object)blockName);
            }
        }
    }

    protected void addBlockAllWood(String modid, List<String> MAT_WOOD) {
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.BRIDGES_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.ROOFS_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.FENCES_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.FURNITURES_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.STAIRS_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.PATHS_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.DOORS_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.TRAPDOORS_WOOD_BLOCKS);
        this.addBlock(modid, MAT_WOOD, McwBlocksIdBase.WINDOWS_WOOD_BLOCKS);
    }

    protected void addBlockHedges(String modid, List<String> MAT_LEAVE) {
        this.addBlock(modid, MAT_LEAVE, McwBlocksIdBase.FENCES_LEAVE_BLOCKS);
    }

    protected void addBlockAllStone(String modid, List<String> MAT_ROCK) {
        this.addBlock(modid, MAT_ROCK, McwBlocksIdBase.BRIDGES_STONE_BLOCKS);
        this.addBlock(modid, MAT_ROCK, McwBlocksIdBase.ROOFS_STONE_BLOCKS);
        this.addBlock(modid, MAT_ROCK, McwBlocksIdBase.FENCES_STONE_BLOCKS);
    }

    protected void makeLootTables() {
        for (class_2248 block : this.blockSet) {
            if (block instanceof class_2323) {
                this.addDoorDrop(block);
                continue;
            }
            this.method_46025(block);
        }
    }

    protected void addDoorDrop(class_2248 block) {
        this.method_45994(block, blockLootTable -> this.method_46022(block));
    }
}

