/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib;

import fr.samlegamer.addonslib.AddonsLib;
import fr.samlegamer.addonslib.data.ModType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class Registration {
    private Registration() {
    }

    public static ModType[] getAllModTypeWood() {
        return new ModType[]{ModType.ROOFS, ModType.FENCES, ModType.BRIDGES, ModType.FURNITURES, ModType.WINDOWS, ModType.DOORS, ModType.TRAPDOORS, ModType.PATHS, ModType.STAIRS};
    }

    public static ModType[] getAllModTypeStone() {
        return new ModType[]{ModType.ROOFS, ModType.FENCES, ModType.BRIDGES};
    }

    public static DeferredRegister<Block> blocks(String MODID) {
        return DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MODID);
    }

    public static DeferredRegister<Item> items(String MODID) {
        return DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MODID);
    }

    public static DeferredRegister<CreativeModeTab> creativeModeTab(String MODID) {
        return DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)MODID);
    }

    public static RegistryObject<CreativeModeTab> tabs(DeferredRegister<CreativeModeTab> event, String MODID, String id, ItemLike icon) {
        return event.register(id, () -> CreativeModeTab.builder().icon(() -> new ItemStack(icon)).title((Component)Component.translatable((String)(MODID + "." + id))).build());
    }

    public static void init(FMLJavaModLoadingContext fmlJavaModLoadingContext, DeferredRegister<Block> b, DeferredRegister<Item> i, DeferredRegister<CreativeModeTab> t) {
        IEventBus bus = fmlJavaModLoadingContext.getModEventBus();
        b.register(bus);
        i.register(bus);
        t.register(bus);
    }

    public static Block getField(String path, BlockBehaviour.Properties prop, Class<?>[] params, Object ... values) {
        Block block;
        try {
            Class<?> classBase = Class.forName(path);
            Constructor<?> constructorBase = classBase.getConstructor(params);
            block = (Block)constructorBase.newInstance(values);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            AddonsLib.LOGGER.error((Object)e);
            block = new Block(prop);
        }
        return block;
    }

    public static Block getBlocksField(String path, BlockBehaviour.Properties WOOD) {
        return Registration.getField(path, WOOD, new Class[]{BlockBehaviour.Properties.class}, WOOD);
    }

    public static Block getBlocksField(String path, BlockBehaviour.Properties WOOD, BlockSetType set) {
        return Registration.getField(path, WOOD, new Class[]{BlockBehaviour.Properties.class, BlockSetType.class}, WOOD, set);
    }

    public static Block getBlocksField(String path, BlockBehaviour.Properties WOOD, BlockState state) {
        return Registration.getField(path, WOOD, new Class[]{BlockState.class, BlockBehaviour.Properties.class}, state, WOOD);
    }
}

