/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.roofs;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class Roofs {
    public static final String modid = "mcwroofs";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Roofs.setRegistrationWoodModLoaded(set, block, item, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS));
    }

    public static void setRegistrationRock(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Roofs.setRegistrationRockModLoaded(rock, block, item, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CUT_SANDSTONE));
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairsBlock")) {
                    CreateBlockReferences.createBlock(id, () -> new StairBlock(Blocks.OAK_PLANKS.defaultBlockState(), WOOD), block, item);
                    continue;
                }
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD, Blocks.OAK_PLANKS.defaultBlockState()), block, item);
                        continue;
                    }
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD), block, item);
            }
        }
    }

    public static void setRegistrationRockModLoaded(List<String> rock, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        boolean isModMcwLoaded = ModList.get().isLoaded(modid);
        for (String i : rock) {
            for (BlockId blockId : McwBlocksIdBase.ROOFS_STONE_BLOCKS.blocks()) {
                RegistryObject<Block> blockObj;
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("StairsBlock")) {
                    blockObj = CreateBlockReferences.createBlockStone(id, () -> new StairBlock(Blocks.COBBLESTONE.defaultBlockState(), STONE), block, item);
                    continue;
                }
                if (isModMcwLoaded) {
                    if (blockId.reflectedLocation().contains("Lower") || blockId.reflectedLocation().contains("Steep")) {
                        blockObj = CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE, Blocks.COBBLESTONE.defaultBlockState()), block, item);
                        continue;
                    }
                    blockObj = CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                RegistryObject<Block> registryObject = CreateBlockReferences.createBlockStone(id, () -> new Block(STONE), block, item);
            }
        }
    }
}

