/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.door;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredRegister;

public class Doors {
    public static final String modid = "mcwdoors";

    public static void setRegistrationWood(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item) {
        BlockBehaviour.Properties JAPAN = BlockBehaviour.Properties.of().noOcclusion().strength(1.5f, 1.0f).sound(SoundType.WOOD);
        BlockBehaviour.Properties DOOR_WOOD = BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_DOOR);
        Doors.setRegistrationWoodModLoaded(set, block, item, JAPAN, DOOR_WOOD);
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister.Blocks block, DeferredRegister.Items item, BlockBehaviour.Properties japan_door, BlockBehaviour.Properties wood_door) {
        BlockBehaviour.Properties JAPAN = japan_door;
        BlockBehaviour.Properties DOOR_WOOD = wood_door;
        boolean isModLoaded = ModList.get().isLoaded(modid);
        BlockSetType blockSetType = DOOR_WOOD.equals(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_DOOR)) ? BlockSetType.CHERRY : BlockSetType.OAK;
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.DOORS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (blockId.reflectedLocation().contains("DoorBlock")) {
                    CreateBlockReferences.createBlock(id, registryName -> new DoorBlock(blockSetType, DOOR_WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
                    continue;
                }
                if (isModLoaded) {
                    CreateBlockReferences.createBlock(id, registryName -> Registration.getBlocksField(blockId.reflectedLocation(), JAPAN.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName)), blockSetType), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, registryName -> new DoorBlock(blockSetType, DOOR_WOOD.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)registryName))), block, item);
            }
        }
    }
}

