/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.tags;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class McwItemTags
extends ItemTagsProvider {
    public McwItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, String modId) {
        super(output, lookupProvider, blockTags, modId);
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> STONE, List<String> LEAVE) {
        this.mcwFencesTags(modid, WOOD, LEAVE, STONE);
        this.mcwDoorsTagsWood(modid, WOOD);
        this.mcwTrapdoorsTagsWood(modid, WOOD);
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> LEAVE) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>(), LEAVE);
    }

    public void addAllMcwTags(String modid, List<String> WOOD) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>());
    }

    public void mcwFencesTags(String modid, List<String> WOOD, List<String> LEAVE, List<String> STONE) {
        HashSet<Item> blocksWood = new HashSet<Item>();
        ArrayList<Item> blocksLeave = new ArrayList<Item>();
        HashSet<Item> blocksStone = new HashSet<Item>();
        this.addItems(modid, WOOD, blocksWood, McwBlocksIdBase.FENCES_WOOD_BLOCKS);
        this.addItems(modid, LEAVE, blocksLeave, McwBlocksIdBase.FENCES_LEAVE_BLOCKS);
        this.addItems(modid, STONE, blocksStone, McwBlocksIdBase.FENCES_STONE_BLOCKS);
        Object[] picket_fences = this.getSetWithContain(blocksWood, "picket_fence");
        Object[] stockade_fences = this.getSetWithContain(blocksWood, "stockade_fence");
        Object[] horse_fences = this.getSetWithContain(blocksWood, "horse_fence");
        Object[] wired_fences = this.getSetWithContain(blocksWood, "wired_fence");
        Object[] curved_gates = this.getSetWithContain(blocksWood, "curved_gate");
        Object[] hedges = this.listToArray(blocksLeave);
        Object[] modern_wall = this.getSetWithStartsWith(blocksStone, "modern_");
        Object[] railing_wall = this.getSetWithStartsWith(blocksStone, "railing_");
        Object[] pillar_wall = this.getSetWithEndsWith(blocksStone, "_pillar_wall");
        Object[] grass_topped_wall = this.getSetWithEndsWith(blocksStone, "_grass_topped_wall");
        this.tag(ItemTags.FENCES).add(modern_wall).add(pillar_wall).add(railing_wall).add(picket_fences).add(stockade_fences).add(horse_fences).add(wired_fences).add(curved_gates);
        this.tag(ItemTags.WALLS).add(hedges).add(grass_topped_wall);
        this.tag(ItemTags.WOODEN_FENCES).add(picket_fences).add(stockade_fences).add(horse_fences).add(wired_fences).add(curved_gates);
    }

    public void mcwDoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String mat : MAT) {
            for (BlockId blockId : McwBlocksIdBase.DOORS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                Item block = Finder.findItem(modid, id);
                items.add(block);
            }
        }
        Object[] itemArray = this.listToArray(items);
        this.tag(ItemTags.WOODEN_DOORS).add(itemArray);
    }

    public void mcwTrapdoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<Item> items = new ArrayList<Item>();
        for (String mat : MAT) {
            for (BlockId blockId : McwBlocksIdBase.TRAPDOORS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                Item block = Finder.findItem(modid, id);
                items.add(block);
            }
        }
        Object[] itemArray = this.listToArray(items);
        this.tag(ItemTags.WOODEN_TRAPDOORS).add(itemArray);
    }

    public static TagKey<Block> getTag(String id, String tagName) {
        return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)id, (String)tagName));
    }

    private Item[] getSetWithContain(Set<Item> blocks, String contain) {
        ArrayList<Item> finalBlocks = new ArrayList<Item>();
        for (Item block : blocks) {
            if (!Finder.getIdOfItem(block).contains(contain)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private Item[] getSetWithEndsWith(Set<Item> blocks, String endsWith) {
        ArrayList<Item> finalBlocks = new ArrayList<Item>();
        for (Item block : blocks) {
            if (!Finder.getIdOfItem(block).endsWith(endsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private Item[] getSetWithStartsWith(Set<Item> blocks, String startsWith) {
        ArrayList<Item> finalBlocks = new ArrayList<Item>();
        for (Item block : blocks) {
            if (!Finder.getIdOfItem(block).startsWith(startsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private Item[] listToArray(List<Item> finalBlocks) {
        Item[] blockArray = new Item[finalBlocks.size()];
        for (int i = 0; i < finalBlocks.size(); ++i) {
            blockArray[i] = finalBlocks.get(i);
        }
        return blockArray;
    }

    private void addItems(String modid, List<String> MAT, Collection<Item> blockSet, McwBlockIdBase blocks) {
        for (String mat : MAT) {
            for (BlockId blockId : blocks.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                Item item = Finder.findItem(modid, id);
                blockSet.add(item);
            }
        }
    }
}

