/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.cfg;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import fr.samlegamer.addonslib.AddonsLib;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.fabricmc.loader.api.FabricLoader;

public class Cfg {
    public static void initCfg() {
        if (!FabricLoader.getInstance().getConfigDir().resolve("addonslib-common.json").toFile().exists()) {
            try (JsonWriter writer = new JsonWriter((Writer)new FileWriter(FabricLoader.getInstance().getConfigDir().toString() + File.separator + "addonslib-common.json"));){
                writer.beginObject();
                writer.name("filterLogs").value(true);
                writer.endObject();
                AddonsLib.LOGGER.info("AddonsLib config file created: addonslib-common.json");
            }
            catch (IOException e) {
                AddonsLib.LOGGER.error((Object)e);
            }
        }
    }

    public static boolean getFilterLogs() {
        try {
            Gson gson;
            JsonObject json;
            File configFile = FabricLoader.getInstance().getConfigDir().resolve("addonslib-common.json").toFile();
            if (configFile.exists() && (json = (JsonObject)(gson = new Gson()).fromJson((Reader)new FileReader(configFile), JsonObject.class)).has("filterLogs") && json.get("filterLogs").isJsonPrimitive()) {
                return json.get("filterLogs").getAsBoolean();
            }
        }
        catch (IOException e) {
            AddonsLib.LOGGER.error("Failed to read config file: addonslib-common.json", (Throwable)e);
        }
        return true;
    }
}

