/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.Bridges;
import fr.samlegamer.addonslib.generation.recipes.Doors;
import fr.samlegamer.addonslib.generation.recipes.Fences;
import fr.samlegamer.addonslib.generation.recipes.Furnitures;
import fr.samlegamer.addonslib.generation.recipes.Paths;
import fr.samlegamer.addonslib.generation.recipes.Roofs;
import fr.samlegamer.addonslib.generation.recipes.Stairs;
import fr.samlegamer.addonslib.generation.recipes.Trapdoors;
import fr.samlegamer.addonslib.generation.recipes.Windows;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.fabric.api.resource.conditions.v1.DefaultResourceConditions;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_3981;
import net.minecraft.class_7800;

public class McwRecipes
extends FabricRecipeProvider {
    private final String modid;
    private final String mcwModid;
    private final String originalMod;

    public McwRecipes(FabricDataOutput output, String modid, String mcwModid, String originalMod) {
        super(output);
        this.modid = modid;
        this.mcwModid = mcwModid;
        this.originalMod = originalMod;
    }

    private AbstractType getFromModType(ModType modType, String modid, String originalMod) {
        return switch (modType) {
            case ModType.BRIDGES -> new Bridges(this.output, modid, originalMod);
            case ModType.DOORS -> new Doors(this.output, modid, originalMod);
            case ModType.FENCES -> new Fences(this.output, modid, originalMod);
            case ModType.FURNITURES -> new Furnitures(this.output, modid, originalMod);
            case ModType.PATHS -> new Paths(this.output, modid, originalMod);
            case ModType.ROOFS -> new Roofs(this.output, modid, originalMod);
            case ModType.STAIRS -> new Stairs(this.output, modid, originalMod);
            case ModType.TRAPDOORS -> new Trapdoors(this.output, modid, originalMod);
            case ModType.WINDOWS -> new Windows(this.output, modid, originalMod);
            default -> null;
        };
    }

    public void onRegisterMcwWood(ModType modType, Consumer<class_2444> exporter, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        AbstractType abstractType = this.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildWood(exporter, MAT, woodMats);
        }
    }

    public void onRegisterMcwStone(ModType modType, Consumer<class_2444> exporter, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        AbstractType abstractType = this.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildStone(exporter, MAT, stoneMats);
        }
    }

    public void registerAllMcwWood(Consumer<class_2444> exporter, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        this.onRegisterMcwWood(ModType.BRIDGES, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.DOORS, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.FENCES, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.FURNITURES, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.PATHS, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.ROOFS, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.STAIRS, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.TRAPDOORS, exporter, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.WINDOWS, exporter, modid, originalMod, MAT, woodMats);
    }

    public void registerAllMcwStone(Consumer<class_2444> exporter, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        this.onRegisterMcwStone(ModType.BRIDGES, exporter, modid, originalMod, MAT, stoneMats);
        this.onRegisterMcwStone(ModType.ROOFS, exporter, modid, originalMod, MAT, stoneMats);
        this.onRegisterMcwStone(ModType.FENCES, exporter, modid, originalMod, MAT, stoneMats);
    }

    public void registerMcwHedge(Consumer<class_2444> exporter, String modid, String originalMod, List<String> MAT, List<class_2248> leave) {
        AbstractType abstractType = this.getFromModType(ModType.FENCES, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildHedge(exporter, MAT, leave);
        }
    }

    protected void mkScW1Item(Consumer<class_2444> exporter, class_1935 result, class_1935 firstItem) {
        String recipeId = Objects.requireNonNull(result.method_8389().toString()) + "_stonecutter";
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_3981 builder = class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{firstItem}), (class_7800)class_7800.field_40634, (class_1935)result).method_17970(McwRecipes.method_32807((class_1935)firstItem), (class_184)McwRecipes.method_10426((class_1935)firstItem));
        builder.method_36443(recipeExporter, recipeId);
    }

    protected void mkRpW4Items(Consumer<class_2444> exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, class_1935 thirdItem, class_1935 fourItem, String group) {
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10434(Character.valueOf('D'), fourItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpW3Items(Consumer<class_2444> exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, class_1935 thirdItem, String group) {
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10434(Character.valueOf('C'), thirdItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpW2Items(Consumer<class_2444> exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, class_1935 secondItem, String group) {
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10434(Character.valueOf('B'), secondItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpW1Item(Consumer<class_2444> exporter, class_1935 planks, String[] pattern, class_1935 result, int count, class_1935 firstItem, String group) {
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2447 shapedRecipeJsonBuilder = pattern.length == 3 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10439(pattern[2]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : (pattern.length == 2 ? class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10439(pattern[1]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)) : class_2447.method_10436((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10439(pattern[0]).method_10434(Character.valueOf('A'), firstItem).method_10435(group).method_10429(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks)));
        shapedRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpShapelessW1Item(Consumer<class_2444> exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, int required, String group, String suffix) {
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2450 shapelessRecipeJsonBuilder = class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10449(firstItem, required).method_10452(group).method_10442(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks));
        shapelessRecipeJsonBuilder.method_36443(recipeExporter, result.method_8389().toString() + suffix);
    }

    protected void mkRpShapelessW1Item(Consumer<class_2444> exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, int require, String group) {
        Consumer recipeExporter = this.withConditions(exporter, new ConditionJsonProvider[]{DefaultResourceConditions.allModsLoaded((String[])new String[]{this.mcwModid, this.originalMod})});
        class_2450 shapelessRecipeJsonBuilder = class_2450.method_10448((class_7800)class_7800.field_40634, (class_1935)result, (int)count).method_10449(firstItem, require).method_10452(group).method_10442(McwRecipes.method_32807((class_1935)planks), (class_184)McwRecipes.method_10426((class_1935)planks));
        shapelessRecipeJsonBuilder.method_10431(recipeExporter);
    }

    protected void mkRpShapelessW1Item(Consumer<class_2444> exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, String group) {
        this.mkRpShapelessW1Item(exporter, planks, result, count, firstItem, 1, group);
    }

    protected void mkRpShapelessW1Item(Consumer<class_2444> exporter, class_1935 planks, class_1935 result, int count, class_1935 firstItem, String group, String suffix) {
        this.mkRpShapelessW1Item(exporter, planks, result, count, firstItem, 1, group, suffix);
    }

    public String method_10321() {
        return this.modid + " Recipe Generator";
    }

    public void method_10419(Consumer<class_2444> consumer) {
    }
}

