/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.recipes;

import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.generation.recipes.AbstractType;
import fr.samlegamer.addonslib.generation.recipes.Bridges;
import fr.samlegamer.addonslib.generation.recipes.Doors;
import fr.samlegamer.addonslib.generation.recipes.Fences;
import fr.samlegamer.addonslib.generation.recipes.Furnitures;
import fr.samlegamer.addonslib.generation.recipes.Paths;
import fr.samlegamer.addonslib.generation.recipes.Roofs;
import fr.samlegamer.addonslib.generation.recipes.Stairs;
import fr.samlegamer.addonslib.generation.recipes.Trapdoors;
import fr.samlegamer.addonslib.generation.recipes.Windows;
import fr.samlegamer.addonslib.generation.recipes.mat.McwStoneMat;
import fr.samlegamer.addonslib.generation.recipes.mat.McwWoodMat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import org.jetbrains.annotations.NotNull;

public class McwRecipes
extends RecipeProvider {
    private final String modid;
    private final String mcwModid;
    private final String originalMod;
    private final PackOutput packOutput;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public McwRecipes(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, String modid, String mcwModid, String originalMod) {
        super(packOutput, registries);
        this.modid = modid;
        this.mcwModid = mcwModid;
        this.originalMod = originalMod;
        this.packOutput = packOutput;
        this.registries = registries;
    }

    private AbstractType getFromModType(ModType modType, String modid, String originalMod) {
        return switch (modType) {
            case ModType.BRIDGES -> new Bridges(this.packOutput, this.registries, modid, originalMod);
            case ModType.DOORS -> new Doors(this.packOutput, this.registries, modid, originalMod);
            case ModType.FENCES -> new Fences(this.packOutput, this.registries, modid, originalMod);
            case ModType.FURNITURES -> new Furnitures(this.packOutput, this.registries, modid, originalMod);
            case ModType.PATHS -> new Paths(this.packOutput, this.registries, modid, originalMod);
            case ModType.ROOFS -> new Roofs(this.packOutput, this.registries, modid, originalMod);
            case ModType.STAIRS -> new Stairs(this.packOutput, this.registries, modid, originalMod);
            case ModType.TRAPDOORS -> new Trapdoors(this.packOutput, this.registries, modid, originalMod);
            case ModType.WINDOWS -> new Windows(this.packOutput, this.registries, modid, originalMod);
            default -> null;
        };
    }

    public void onRegisterMcwWood(ModType modType, RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        AbstractType abstractType = this.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildWood(output, MAT, woodMats);
        }
    }

    public void onRegisterMcwStone(ModType modType, RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        AbstractType abstractType = this.getFromModType(modType, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildStone(output, MAT, stoneMats);
        }
    }

    public void registerAllMcwWood(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwWoodMat> woodMats) {
        this.onRegisterMcwWood(ModType.BRIDGES, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.DOORS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.FENCES, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.FURNITURES, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.PATHS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.ROOFS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.STAIRS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.TRAPDOORS, output, modid, originalMod, MAT, woodMats);
        this.onRegisterMcwWood(ModType.WINDOWS, output, modid, originalMod, MAT, woodMats);
    }

    public void registerAllMcwStone(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<McwStoneMat> stoneMats) {
        this.onRegisterMcwStone(ModType.BRIDGES, output, modid, originalMod, MAT, stoneMats);
        this.onRegisterMcwStone(ModType.ROOFS, output, modid, originalMod, MAT, stoneMats);
        this.onRegisterMcwStone(ModType.FENCES, output, modid, originalMod, MAT, stoneMats);
    }

    public void registerMcwHedge(RecipeOutput output, String modid, String originalMod, List<String> MAT, List<Block> leave) {
        AbstractType abstractType = this.getFromModType(ModType.FENCES, modid, originalMod);
        if (abstractType != null) {
            abstractType.buildHedge(output, MAT, leave);
        }
    }

    protected void mkScW1Item(RecipeOutput output, ItemLike result, ItemLike firstItem) {
        String recipeId = this.modid + ":" + Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()) + "_stonecutter";
        ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((SingleItemRecipeBuilder)SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{firstItem}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).unlockedBy(McwRecipes.getHasName((ItemLike)firstItem), McwRecipes.has((ItemLike)firstItem))).save(arg_0)).save(output, ResourceLocation.parse((String)recipeId));
    }

    protected void mkRpW4Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, ItemLike fourItem, String group) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).define(Character.valueOf('D'), fourItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        }
    }

    protected void mkRpW3Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, ItemLike thirdItem, String group) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).define(Character.valueOf('C'), thirdItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        }
    }

    protected void mkRpW2Items(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, ItemLike secondItem, String group) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).define(Character.valueOf('B'), secondItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        }
    }

    protected void mkRpW1Item(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, String group, String suffix) {
        ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath() + suffix)));
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group, String suffix) {
        ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).requires(firstItem, required).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)(BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath() + suffix)));
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, int required, String group) {
        ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapelessRecipeBuilder)ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).requires(firstItem, required).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, String group) {
        this.mkRpShapelessW1Item(output, planks, result, count, firstItem, 1, group);
    }

    protected void mkRpShapelessW1Item(RecipeOutput output, ItemLike planks, ItemLike result, int count, ItemLike firstItem, String group, String suffix) {
        this.mkRpShapelessW1Item(output, planks, result, count, firstItem, 1, group, suffix);
    }

    protected void mkRpW1Item(RecipeOutput output, ItemLike planks, String[] pattern, ItemLike result, int count, ItemLike firstItem, String group) {
        if (pattern.length == 3) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).pattern(pattern[2]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else if (pattern.length == 2) {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).pattern(pattern[1]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        } else {
            ConditionalRecipe.builder().condition((ICondition)new AndCondition(List.of(new ModLoadedCondition(this.mcwModid), new ModLoadedCondition(this.originalMod)))).recipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)count).pattern(pattern[0]).define(Character.valueOf('A'), firstItem).group(group).unlockedBy(McwRecipes.getHasName((ItemLike)planks), McwRecipes.has((ItemLike)planks))).save(arg_0)).save(output, ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)BuiltInRegistries.ITEM.getKey((Object)result.asItem()).getPath()));
        }
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeOutput) {
    }
}

