/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.bridges;

import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.CreateBlockReferences;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class Bridges {
    public static final String modid = "mcwbridges";
    public static final String desc = "mcwbridges.bridges.desc";

    public static void setRegistrationWood(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Bridges.setRegistrationWoodModLoaded(set, block, item, BlockBehaviour.Properties.of().strength(0.5f, 2.5f).sound(SoundType.WOOD));
    }

    public static void setRegistrationRock(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item) {
        Bridges.setRegistrationRockModLoaded(set, block, item, BlockBehaviour.Properties.of().strength(3.0f, 5.0f).sound(SoundType.STONE));
    }

    public static void setRegistrationRockModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties STONE = prop;
        ModList modList = ModList.get();
        boolean isModMcwLoaded = modList.isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_STONE_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlockStone(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), STONE), block, item);
                    continue;
                }
                CreateBlockReferences.createBlockStone(id, () -> new Block(STONE), block, item);
            }
        }
    }

    public static void setRegistrationWoodModLoaded(List<String> set, DeferredRegister<Block> block, DeferredRegister<Item> item, BlockBehaviour.Properties prop) {
        BlockBehaviour.Properties WOOD = prop;
        ModList modList = ModList.get();
        boolean isModMcwLoaded = modList.isLoaded(modid);
        for (String i : set) {
            for (BlockId blockId : McwBlocksIdBase.BRIDGES_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), i);
                if (isModMcwLoaded) {
                    CreateBlockReferences.createBlock(id, () -> Registration.getBlocksField(blockId.reflectedLocation(), WOOD), block, item);
                    continue;
                }
                CreateBlockReferences.createBlock(id, () -> new Block(WOOD), block, item);
            }
        }
    }
}

