/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.tags;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public abstract class McwBlockTags
extends FabricTagProvider.BlockTagProvider {
    public McwBlockTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> STONE, List<String> LEAVE) {
        this.mcwWindowsTags(modid, WOOD);
        this.mcwStairsTags(modid, WOOD);
        this.mcwRoofsTags(modid, WOOD, STONE);
        this.mcwPathsTags(modid, WOOD);
        this.mcwFurnituresTags(modid, WOOD);
        this.mcwFencesTags(modid, WOOD, LEAVE, STONE);
        this.mcwBridgesTagsWood(modid, WOOD);
        this.mcwDoorsTagsWood(modid, WOOD);
        this.mcwTrapdoorsTagsWood(modid, WOOD);
        if (!STONE.isEmpty()) {
            this.mcwBridgesTagsStone(modid, STONE);
        }
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> LEAVE) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>(), LEAVE);
    }

    public void addAllMcwTags(String modid, List<String> WOOD) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>());
    }

    public void mcwWindowsTags(String modid, List<String> WOOD) {
        HashSet<class_2248> blocksWood = new HashSet<class_2248>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.WINDOWS_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(class_3481.field_15504).add((Object[])this.getSetWithEndsWith(blocksWood, "_window2")).add((Object[])this.getSetWithEndsWith(blocksWood, "_window"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "blinds")).add((Object[])this.getSetWithEndsWith(blocksWood, "_blinds"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "curtain_rods")).add((Object[])this.getSetWithEndsWith(blocksWood, "_curtain_rod"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "parapets")).add((Object[])this.getSetWithEndsWith(blocksWood, "_log_parapet"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "shutters")).add((Object[])this.getSetWithEndsWith(blocksWood, "_shutter"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "windows_four")).add((Object[])this.getSetWithEndsWith(blocksWood, "_four_window"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "windows_two")).add((Object[])this.getSetWithEndsWith(blocksWood, "_window2"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwwindows", "windows")).add((Object[])this.getSetWithEndsWith(blocksWood, "_window"));
    }

    public void mcwStairsTags(String modid, List<String> WOOD) {
        HashSet<class_2248> blocksWood = new HashSet<class_2248>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.STAIRS_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "balconies")).add((Object[])this.getSetWithEndsWith(blocksWood, "_balcony"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "bulk_stairs")).add((Object[])this.getSetWithEndsWith(blocksWood, "_bulk_stairs"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "compact_stairs")).add((Object[])this.getSetWithEndsWith(blocksWood, "_compact_stairs"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "loft_stairs")).add((Object[])this.getSetWithEndsWith(blocksWood, "_loft_stairs"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "platforms")).add((Object[])this.getSetWithEndsWith(blocksWood, "_platform"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "railings")).add((Object[])this.getSetWithEndsWith(blocksWood, "_railing"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "skyline_stairs")).add((Object[])this.getSetWithEndsWith(blocksWood, "_skyline_stairs"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwstairs", "terrace_stairs")).add((Object[])this.getSetWithEndsWith(blocksWood, "_terrace_stairs"));
    }

    public void mcwRoofsTags(String modid, List<String> WOOD, List<String> STONE) {
        HashSet<class_2248> blocksWood = new HashSet<class_2248>();
        HashSet<class_2248> blocksStone = new HashSet<class_2248>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.ROOFS_WOOD_BLOCKS);
        this.addBlocks(modid, STONE, blocksStone, McwBlocksIdBase.ROOFS_STONE_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(class_3481.field_33715).add((Object[])this.listToArray(blocksStone.stream().toList()));
    }

    public void mcwPathsTags(String modid, List<String> WOOD) {
        ArrayList<class_2248> blocksWood = new ArrayList<class_2248>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.PATHS_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwpaths", "wooden_paths")).add((Object[])this.listToArray(blocksWood));
    }

    public void mcwFurnituresTags(String modid, List<String> WOOD) {
        HashSet<class_2248> blocksWood = new HashSet<class_2248>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.FURNITURES_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfurnitures", "enchantment_power_provider")).add((Object[])this.getSetWithContain(blocksWood, "bookshelf"));
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("bookshelf_cupboard", Collections.singletonList("_bookshelf_cupboard"));
        map.put("bookshelf_drawer", Collections.singletonList("_bookshelf_drawer"));
        map.put("bookshelf", Collections.singletonList("_bookshelf"));
        map.put("cabinet", Arrays.asList("_kitchen_cabinet", "_double_kitchen_cabinet", "_glass_kitchen_cabinet"));
        map.put("chair", Collections.singletonList("_chair"));
        map.put("coffee_table", Collections.singletonList("_coffee_table"));
        map.put("counter", Collections.singletonList("_counter"));
        map.put("covered_desk", Collections.singletonList("_covered_desk"));
        map.put("cupboard_counter", Collections.singletonList("_cupboard_counter"));
        map.put("desk", Collections.singletonList("_desk"));
        map.put("double_drawer_counter", Collections.singletonList("_double_drawer_counter"));
        map.put("double_drawer", Collections.singletonList("_double_drawer"));
        map.put("double_wardrobe", Collections.singletonList("_double_wardrobe"));
        map.put("drawer", Collections.singletonList("_drawer"));
        map.put("end_table", Collections.singletonList("_end_table"));
        map.put("glass_table", Collections.singletonList("_glass_table"));
        map.put("large_drawer", Collections.singletonList("_large_drawer"));
        map.put("lower_bookshelf_drawer", Collections.singletonList("_lower_bookshelf_drawer"));
        map.put("lower_triple_drawer", Collections.singletonList("_lower_triple_drawer"));
        map.put("modern_chair", Collections.singletonList("_modern_chair"));
        map.put("modern_desk", Collections.singletonList("_modern_desk"));
        map.put("modern_wardrobe", Collections.singletonList("_modern_wardrobe"));
        map.put("stool_chair", Collections.singletonList("_stool_chair"));
        map.put("striped_chair", Collections.singletonList("_striped_chair"));
        map.put("table", Collections.singletonList("_table"));
        map.put("triple_drawer", Collections.singletonList("_triple_drawer"));
        map.put("wadrobe", Collections.singletonList("_wardrobe"));
        map.put("kitchen_sink", Collections.singletonList("_kitchen_sink"));
        for (Map.Entry mapEntry : map.entrySet()) {
            List list = (List)mapEntry.getValue();
            ArrayList<class_2248> blocks = new ArrayList<class_2248>();
            for (String mat : WOOD) {
                for (String i : list) {
                    blocks.add(Finder.findBlock(modid, mat + i));
                    blocks.add(Finder.findBlock(modid, "stripped_" + mat + i));
                }
            }
            this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfurnitures", (String)mapEntry.getKey())).add((Object[])this.listToArray(blocks));
        }
    }

    public void mcwFencesTags(String modid, List<String> WOOD, List<String> LEAVE, List<String> STONE) {
        HashSet<class_2248> blocksWood = new HashSet<class_2248>();
        ArrayList<class_2248> blocksLeave = new ArrayList<class_2248>();
        HashSet<class_2248> blocksStone = new HashSet<class_2248>();
        this.addBlocks(modid, WOOD, blocksWood, McwBlocksIdBase.FENCES_WOOD_BLOCKS);
        this.addBlocks(modid, LEAVE, blocksLeave, McwBlocksIdBase.FENCES_LEAVE_BLOCKS);
        this.addBlocks(modid, STONE, blocksStone, McwBlocksIdBase.FENCES_STONE_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(class_3481.field_33715).add((Object[])this.listToArray(blocksStone.stream().toList()));
        this.getOrCreateTagBuilder(class_3481.field_33714).add((Object[])this.listToArray(blocksLeave.stream().toList()));
        Object[] picket_fences = this.getSetWithContain(blocksWood, "picket_fence");
        Object[] stockade_fences = this.getSetWithContain(blocksWood, "stockade_fence");
        Object[] horse_fences = this.getSetWithContain(blocksWood, "horse_fence");
        Object[] wired_fences = this.getSetWithContain(blocksWood, "wired_fence");
        Object[] highley_gates = this.getSetWithContain(blocksWood, "highley_gate");
        Object[] pyramid_gates = this.getSetWithContain(blocksWood, "pyramid_gate");
        Object[] curved_gates = this.getSetWithContain(blocksWood, "curved_gate");
        Object[] hedges = this.listToArray(blocksLeave);
        Object[] modern_wall = this.getSetWithStartsWith(blocksStone, "modern_");
        Object[] railing_wall = this.getSetWithStartsWith(blocksStone, "railing_");
        Object[] railing_gate = this.getSetWithEndsWith(blocksStone, "_railing_gate");
        Object[] pillar_wall = this.getSetWithEndsWith(blocksStone, "_pillar_wall");
        Object[] grass_topped_wall = this.getSetWithEndsWith(blocksStone, "_grass_topped_wall");
        this.getOrCreateTagBuilder(class_3481.field_25147).add(highley_gates).add(pyramid_gates).add(curved_gates).add(railing_gate);
        this.getOrCreateTagBuilder(class_3481.field_16584).add(hedges).add(modern_wall).add(pillar_wall).add(railing_wall).add(grass_topped_wall).add(picket_fences).add(stockade_fences).add(horse_fences).add(wired_fences).add(curved_gates);
        this.getOrCreateTagBuilder(class_3481.field_15504).add(hedges).add(grass_topped_wall);
        this.getOrCreateTagBuilder(class_3481.field_17619).add(picket_fences).add(stockade_fences).add(horse_fences).add(wired_fences).add(curved_gates);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "curved_double_gates")).add(curved_gates);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "highley_gates")).add(highley_gates);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "horse_fences")).add(horse_fences);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "picket_fences")).add(picket_fences);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "pyramid_gates")).add(pyramid_gates);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "pyramid_gates")).add(pyramid_gates);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "stockade_fences")).add(stockade_fences);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "wired_fences")).add(wired_fences);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "hedges")).add(hedges);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "grass_topped_walls")).add(grass_topped_wall);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "modern_walls")).add(modern_wall);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "pillar_walls")).add(pillar_wall);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "railing_gates")).add(railing_gate);
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwfences", "railing_walls")).add(railing_wall);
    }

    public void mcwBridgesTagsWood(String modid, List<String> MAT) {
        HashSet<class_2248> blocksWood = new HashSet<class_2248>();
        this.addBlocks(modid, MAT, blocksWood, McwBlocksIdBase.BRIDGES_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocksWood.stream().toList()));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "log_bridges")).add((Object[])this.getSetWithContain(blocksWood, "log_bridge_middle"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "log_stairs")).add((Object[])this.getSetWithContain(blocksWood, "log_bridge_stair"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "rail_bridges")).add((Object[])this.getSetWithContain(blocksWood, "rail_bridge"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "rope_bridges")).add((Object[])this.getSetWithStartsWith(blocksWood, "rope_"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "rope_stairs")).add((Object[])this.getSetWithContain(blocksWood, "rope_bridge_stair"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "wooden_piers")).add((Object[])this.getSetWithContain(blocksWood, "bridge_pier"));
    }

    public void mcwBridgesTagsStone(String modid, List<String> MAT) {
        HashSet<class_2248> blocks = new HashSet<class_2248>();
        this.addBlocks(modid, MAT, blocks, McwBlocksIdBase.BRIDGES_STONE_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33715).add((Object[])this.listToArray(blocks.stream().toList()));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "stone_bridges")).add((Object[])this.getSetWithEndsWith(blocks, "_bridge"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "stone_piers")).add((Object[])this.getSetWithContain(blocks, "bridge_pier"));
        this.getOrCreateTagBuilder(McwBlockTags.getTag("mcwbridges", "stone_stairs")).add((Object[])this.getSetWithContain(blocks, "bridge_stair"));
    }

    public void mcwDoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        this.addBlocks(modid, MAT, blocks, McwBlocksIdBase.DOORS_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocks.stream().toList()));
        Object[] blockArray = this.listToArray(blocks);
        this.getOrCreateTagBuilder(class_3481.field_15494).add(blockArray);
        HashMap<String, String> moddedTag = new HashMap<String, String>();
        moddedTag.put("bamboo", "bamboo");
        moddedTag.put("barn", "barn");
        moddedTag.put("barn_glass", "barn_glass");
        moddedTag.put("beach", "beach");
        moddedTag.put("classic", "classic");
        moddedTag.put("cottage", "cottage");
        moddedTag.put("four_panel", "four_panel");
        moddedTag.put("glass", "glass");
        moddedTag.put("modern", "modern");
        moddedTag.put("mystic", "mystic");
        moddedTag.put("nether", "nether");
        moddedTag.put("paper", "paper");
        moddedTag.put("shoji", "japanese");
        moddedTag.put("shoji_whole", "japanese2");
        moddedTag.put("stable", "stable");
        moddedTag.put("stable_head", "stable_head");
        moddedTag.put("swamp", "swamp");
        moddedTag.put("tropical", "tropical");
        moddedTag.put("waffle", "waffle");
        moddedTag.put("western", "western");
        moddedTag.put("whispering", "whispering");
        for (Map.Entry map : moddedTag.entrySet()) {
            Object[] blocks2 = new class_2248[MAT.size()];
            for (String mat : MAT) {
                class_2248 block = Finder.findBlock(modid, mat + "_" + (String)map.getValue() + "_door");
                blocks2[MAT.indexOf((Object)mat)] = block;
            }
            class_6862<class_2248> tag = McwBlockTags.getTag("mcwdoors", (String)map.getKey() + "_doors");
            this.getOrCreateTagBuilder(tag).add(blocks2);
        }
    }

    public void mcwTrapdoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<class_2248> blocks = new ArrayList<class_2248>();
        this.addBlocks(modid, MAT, blocks, McwBlocksIdBase.TRAPDOORS_WOOD_BLOCKS);
        this.getOrCreateTagBuilder(class_3481.field_33713).add((Object[])this.listToArray(blocks.stream().toList()));
        Object[] blockArray = this.listToArray(blocks);
        this.getOrCreateTagBuilder(class_3481.field_15491).add(blockArray);
        HashMap<String, String> moddedTag = new HashMap<String, String>();
        moddedTag.put("bamboo", "bamboo");
        moddedTag.put("bark", "bark");
        moddedTag.put("barn", "barn");
        moddedTag.put("barred", "barred");
        moddedTag.put("barrel", "barrel");
        moddedTag.put("beach", "beach");
        moddedTag.put("cottage", "cottage");
        moddedTag.put("four_panel", "four_panel");
        moddedTag.put("glass", "glass");
        moddedTag.put("mystic", "mystic");
        moddedTag.put("paper", "paper");
        moddedTag.put("ranch", "ranch");
        moddedTag.put("swamp", "swamp");
        moddedTag.put("tropical", "tropical");
        moddedTag.put("waffle", "blossom");
        moddedTag.put("whispering", "whispering");
        for (Map.Entry map : moddedTag.entrySet()) {
            Object[] blocks2 = new class_2248[MAT.size()];
            for (String mat : MAT) {
                class_2248 block = Finder.findBlock(modid, mat + "_" + (String)map.getValue() + "_trapdoor");
                blocks2[MAT.indexOf((Object)mat)] = block;
            }
            class_6862<class_2248> tag = McwBlockTags.getTag("mcwdoors", (String)map.getKey() + "_trapdoors");
            this.getOrCreateTagBuilder(tag).add(blocks2);
        }
    }

    public static class_6862<class_2248> getTag(String id, String tagName) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_43902((String)id, (String)tagName));
    }

    private class_2248[] getSetWithContain(Set<class_2248> blocks, String contain) {
        ArrayList<class_2248> finalBlocks = new ArrayList<class_2248>();
        for (class_2248 block : blocks) {
            if (!Finder.getIdOfBlock(block).contains(contain)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private class_2248[] getSetWithEndsWith(Set<class_2248> blocks, String endsWith) {
        ArrayList<class_2248> finalBlocks = new ArrayList<class_2248>();
        for (class_2248 block : blocks) {
            if (!Finder.getIdOfBlock(block).endsWith(endsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private class_2248[] getSetWithStartsWith(Set<class_2248> blocks, String startsWith) {
        ArrayList<class_2248> finalBlocks = new ArrayList<class_2248>();
        for (class_2248 block : blocks) {
            if (!Finder.getIdOfBlock(block).startsWith(startsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private class_2248[] listToArray(List<class_2248> finalBlocks) {
        class_2248[] blockArray = new class_2248[finalBlocks.size()];
        for (int i = 0; i < finalBlocks.size(); ++i) {
            blockArray[i] = finalBlocks.get(i);
        }
        return blockArray;
    }

    private void addBlocks(String modid, List<String> MAT, Collection<class_2248> blockSet, McwBlockIdBase blocks) {
        for (String mat : MAT) {
            for (BlockId blockId : blocks.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                class_2248 block = Finder.findBlock(modid, id);
                blockSet.add(block);
            }
        }
    }
}

