/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.addonslib.generation.tags;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.data.BlockId;
import fr.samlegamer.addonslib.data.McwBlockIdBase;
import fr.samlegamer.addonslib.data.McwBlocksIdBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;

public abstract class McwItemTags
extends FabricTagProvider.ItemTagProvider {
    public McwItemTags(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> STONE, List<String> LEAVE) {
        this.mcwFencesTags(modid, WOOD, LEAVE, STONE);
        this.mcwDoorsTagsWood(modid, WOOD);
        this.mcwTrapdoorsTagsWood(modid, WOOD);
    }

    public void addAllMcwTags(String modid, List<String> WOOD, List<String> LEAVE) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>(), LEAVE);
    }

    public void addAllMcwTags(String modid, List<String> WOOD) {
        this.addAllMcwTags(modid, WOOD, new ArrayList<String>());
    }

    public void mcwFencesTags(String modid, List<String> WOOD, List<String> LEAVE, List<String> STONE) {
        HashSet<class_1792> blocksWood = new HashSet<class_1792>();
        ArrayList<class_1792> blocksLeave = new ArrayList<class_1792>();
        HashSet<class_1792> blocksStone = new HashSet<class_1792>();
        this.addItems(modid, WOOD, blocksWood, McwBlocksIdBase.FENCES_WOOD_BLOCKS);
        this.addItems(modid, LEAVE, blocksLeave, McwBlocksIdBase.FENCES_LEAVE_BLOCKS);
        this.addItems(modid, STONE, blocksStone, McwBlocksIdBase.FENCES_STONE_BLOCKS);
        Object[] picket_fences = this.getSetWithContain(blocksWood, "picket_fence");
        Object[] stockade_fences = this.getSetWithContain(blocksWood, "stockade_fence");
        Object[] horse_fences = this.getSetWithContain(blocksWood, "horse_fence");
        Object[] wired_fences = this.getSetWithContain(blocksWood, "wired_fence");
        Object[] curved_gates = this.getSetWithContain(blocksWood, "curved_gate");
        Object[] hedges = this.listToArray(blocksLeave);
        Object[] modern_wall = this.getSetWithStartsWith(blocksStone, "modern_");
        Object[] railing_wall = this.getSetWithStartsWith(blocksStone, "railing_");
        Object[] pillar_wall = this.getSetWithEndsWith(blocksStone, "_pillar_wall");
        Object[] grass_topped_wall = this.getSetWithEndsWith(blocksStone, "_grass_topped_wall");
        this.getOrCreateTagBuilder(class_3489.field_16585).add(modern_wall).add(pillar_wall).add(railing_wall).add(picket_fences).add(stockade_fences).add(horse_fences).add(wired_fences).add(curved_gates);
        this.getOrCreateTagBuilder(class_3489.field_15560).add(hedges).add(grass_topped_wall);
        this.getOrCreateTagBuilder(class_3489.field_17620).add(picket_fences).add(stockade_fences).add(horse_fences).add(wired_fences).add(curved_gates);
    }

    public void mcwDoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (String mat : MAT) {
            for (BlockId blockId : McwBlocksIdBase.DOORS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                class_1792 block = Finder.findItem(modid, id);
                items.add(block);
            }
        }
        Object[] itemArray = this.listToArray(items);
        this.getOrCreateTagBuilder(class_3489.field_15552).add(itemArray);
    }

    public void mcwTrapdoorsTagsWood(String modid, List<String> MAT) {
        ArrayList<class_1792> items = new ArrayList<class_1792>();
        for (String mat : MAT) {
            for (BlockId blockId : McwBlocksIdBase.TRAPDOORS_WOOD_BLOCKS.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                class_1792 block = Finder.findItem(modid, id);
                items.add(block);
            }
        }
        Object[] itemArray = this.listToArray(items);
        this.getOrCreateTagBuilder(class_3489.field_15550).add(itemArray);
    }

    public static class_6862<class_2248> getTag(String id, String tagName) {
        return class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)id, (String)tagName));
    }

    private class_1792[] getSetWithContain(Set<class_1792> blocks, String contain) {
        ArrayList<class_1792> finalBlocks = new ArrayList<class_1792>();
        for (class_1792 block : blocks) {
            if (!Finder.getIdOfItem(block).contains(contain)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private class_1792[] getSetWithEndsWith(Set<class_1792> blocks, String endsWith) {
        ArrayList<class_1792> finalBlocks = new ArrayList<class_1792>();
        for (class_1792 block : blocks) {
            if (!Finder.getIdOfItem(block).endsWith(endsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private class_1792[] getSetWithStartsWith(Set<class_1792> blocks, String startsWith) {
        ArrayList<class_1792> finalBlocks = new ArrayList<class_1792>();
        for (class_1792 block : blocks) {
            if (!Finder.getIdOfItem(block).startsWith(startsWith)) continue;
            finalBlocks.add(block);
        }
        return this.listToArray(finalBlocks);
    }

    private class_1792[] listToArray(List<class_1792> finalBlocks) {
        class_1792[] blockArray = new class_1792[finalBlocks.size()];
        for (int i = 0; i < finalBlocks.size(); ++i) {
            blockArray[i] = finalBlocks.get(i);
        }
        return blockArray;
    }

    private void addItems(String modid, List<String> MAT, Collection<class_1792> blockSet, McwBlockIdBase blocks) {
        for (String mat : MAT) {
            for (BlockId blockId : blocks.blocks()) {
                String id = McwBlocksIdBase.replacement(blockId.id(), mat);
                class_1792 item = Finder.findItem(modid, id);
                blockSet.add(item);
            }
        }
    }
}

