/*
 * Decompiled with CFR 0.152.
 */
package com.jenny.enhancedexplosives.blocks;

import com.jenny.enhancedexplosives.config.ConfigClient;
import com.jenny.enhancedexplosives.entities.tnt.enderPrimedTNT;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class enderTNTBlock
extends TntBlock {
    public final float pRadius;
    public final int fuseTime;

    public enderTNTBlock(BlockBehaviour.Properties p_57422_, float pRadius, int fuseTime) {
        super(p_57422_);
        this.pRadius = pRadius;
        this.fuseTime = fuseTime;
    }

    public void onCaughtFire(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        enderTNTBlock.explode(world, pos, igniter, this.pRadius, this.fuseTime);
    }

    @Deprecated
    public static void explode(Level p_57434_, BlockPos p_57435_, float pRadius, int fuseTime) {
        enderTNTBlock.explode(p_57434_, p_57435_, null, pRadius, fuseTime);
    }

    @Deprecated
    private static void explode(Level level, BlockPos blockPos, @Nullable LivingEntity entity, float pRadius, int fuseTime) {
        if (!level.f_46443_) {
            BlockPos pos = enderTNTBlock.getSpawnPos(level, blockPos);
            if (pos != null) {
                enderPrimedTNT primedtnt = new enderPrimedTNT(level, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, entity, pRadius, fuseTime);
                level.m_7967_((Entity)primedtnt);
                level.m_6263_(null, primedtnt.m_20185_(), primedtnt.m_20186_(), primedtnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_((Entity)entity, GameEvent.f_157776_, blockPos);
            }
        } else {
            enderTNTBlock.spawnParticles(level, blockPos);
        }
    }

    private static BlockPos getSpawnPos(Level level, BlockPos blockPos) {
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        for (int i = 0; i < 5; ++i) {
            BlockPos pos = new BlockPos(x + level.m_213780_().m_216339_(-16, 17), y + level.m_213780_().m_216339_(-16, 17), z + level.m_213780_().m_216339_(-16, 17));
            if (!level.m_46859_(pos)) continue;
            int ymax = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            if (ymax < pos.m_123342_()) {
                return new BlockPos(pos.m_123341_(), ymax, pos.m_123343_());
            }
            return pos;
        }
        return null;
    }

    public void m_7592_(Level level, @NotNull BlockPos blockPos, @NotNull Explosion pExplosion) {
        if (!level.f_46443_) {
            BlockPos pos = enderTNTBlock.getSpawnPos(level, blockPos);
            if (pos != null) {
                enderPrimedTNT primedtnt = new enderPrimedTNT(level, (float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, pExplosion.m_46079_(), this.pRadius, this.fuseTime);
                int i = primedtnt.getFuse();
                primedtnt.setFuse((short)(level.f_46441_.m_188503_(i / 4) + i / 8));
                level.m_7967_((Entity)primedtnt);
            }
        } else {
            enderTNTBlock.spawnParticles(level, blockPos);
        }
    }

    public static void spawnParticles(Level level, BlockPos blockPos) {
        if (((Boolean)ConfigClient.tntParticles.get()).booleanValue()) {
            for (int i = 1; i <= ConfigClient.calcPCount(30); ++i) {
                float x = (float)blockPos.m_123341_() + (float)level.m_213780_().m_216332_(-10, 10) / 10.0f + 0.5f;
                float y = (float)blockPos.m_123342_() + (float)level.m_213780_().m_216332_(-10, 10) / 10.0f;
                float z = (float)blockPos.m_123343_() + (float)level.m_213780_().m_216332_(-10, 10) / 10.0f + 0.5f;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175827_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
            }
        }
    }
}

