/*
 * Decompiled with CFR 0.152.
 */
package com.jenny.enhancedexplosives.blocks;

import com.jenny.enhancedexplosives.entities.tnt.ClusterPrimedTNT;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ClusterTNTBlock
extends TntBlock {
    public final float pRadius;
    public final int fuseTime;
    public final int childCount;
    public final int childRange;

    public ClusterTNTBlock(BlockBehaviour.Properties p_57422_, float pRadius, int fuseTime, int childCount, int childRange) {
        super(p_57422_);
        this.pRadius = pRadius;
        this.fuseTime = fuseTime;
        this.childCount = childCount;
        this.childRange = childRange;
    }

    public void onCaughtFire(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        ClusterTNTBlock.explode(world, pos, igniter, this.pRadius, this.fuseTime, this.childCount, this.childRange);
    }

    @Deprecated
    public static void explode(Level p_57434_, BlockPos p_57435_, float pRadius, int fuseTime, int childCount, int childRange) {
        ClusterTNTBlock.explode(p_57434_, p_57435_, null, pRadius, fuseTime, childCount, childRange);
    }

    public static Vec3 getMove(Level level, int childRange) {
        RandomSource rng = level.m_213780_();
        float offsetX = (float)rng.m_216339_(-childRange, childRange + 1) / 15.0f;
        float offsetZ = (float)rng.m_216339_(-childRange, childRange + 1) / 15.0f;
        return new Vec3((double)offsetX, 0.0, (double)offsetZ);
    }

    @Deprecated
    private static void explode(Level level, BlockPos blockPos, @Nullable LivingEntity entity, float pRadius, int fuseTime, int childCount, int childRange) {
        if (!level.f_46443_) {
            for (int i = 0; i < childCount; ++i) {
                ClusterPrimedTNT primedtnt = new ClusterPrimedTNT(level, (double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, entity, pRadius, fuseTime, ClusterTNTBlock.getMove(level, childRange));
                level.m_7967_((Entity)primedtnt);
                level.m_142346_((Entity)entity, GameEvent.f_157776_, blockPos);
            }
            level.m_6263_((Player)null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void m_7592_(Level level, @NotNull BlockPos blockPos, @NotNull Explosion pExplosion) {
        if (!level.f_46443_) {
            for (int i = 0; i < this.childCount; ++i) {
                short ft = (short)(level.f_46441_.m_188503_(this.fuseTime / 4) + this.fuseTime / 8);
                ClusterPrimedTNT primedtnt = new ClusterPrimedTNT(level, (double)blockPos.m_123341_() + 0.5, blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5, pExplosion.m_46079_(), this.pRadius, ft, ClusterTNTBlock.getMove(level, this.childRange));
                level.m_7967_((Entity)primedtnt);
            }
        }
    }
}

