/*
 * Decompiled with CFR 0.152.
 */
package com.jenny.enhancedexplosives.entities.tnt;

import com.jenny.enhancedexplosives.blocks.blocks;
import com.jenny.enhancedexplosives.config.ConfigClient;
import com.jenny.enhancedexplosives.config.ConfigServer;
import com.jenny.enhancedexplosives.entities.entities;
import com.jenny.enhancedexplosives.entities.tnt.basePrimedTNT;
import com.jenny.enhancedexplosives.util;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class homingPrimedTNT
extends basePrimedTNT {
    private static final EntityDataAccessor<Float> DATA_SPEED_ID = SynchedEntityData.m_135353_(homingPrimedTNT.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    Entity target;

    public homingPrimedTNT(Level pLevel, double pX, double pY, double pZ, @Nullable LivingEntity pOwner, float power, int fuse, float speed) {
        super((EntityType<? extends basePrimedTNT>)((EntityType)entities.TNT_HOMING.get()), pLevel, pOwner, new Vec3(pX, pY, pZ), fuse, power);
        this.target = null;
        this.setSpeed(speed);
    }

    public homingPrimedTNT(EntityType<homingPrimedTNT> entityType, Level level) {
        super(entityType, level);
    }

    private Vec3 targetVector() {
        double targetDist = this.getTargetDist();
        Vec3 targetVec = new Vec3(0.0, 0.0, 0.0);
        if (targetDist > 3.0) {
            float speed = this.getSpeed();
            targetVec = new Vec3(this.target.m_20185_() - this.m_20185_(), this.target.m_20186_() - this.m_20186_(), this.target.m_20189_() - this.m_20189_()).m_82541_().m_82542_((double)speed, (double)speed, (double)speed);
            if (targetDist < 10.0) {
                targetVec.m_82542_(targetDist / 10.0, targetDist / 10.0, targetDist / 10.0);
            }
        }
        return targetVec;
    }

    public double getTargetDist() {
        return new Vec3(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_()).m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82553_();
    }

    public void findTarget() {
        this.target = this.closestEntity(this.getEntities());
    }

    private LivingEntity closestEntity(List<LivingEntity> entities2) {
        double dist = Double.MAX_VALUE;
        LivingEntity target = null;
        for (LivingEntity e : entities2) {
            double newDist = e.m_20182_().m_82554_(this.m_20182_());
            if (!(newDist < dist)) continue;
            target = e;
            dist = newDist;
        }
        return target;
    }

    protected List<LivingEntity> getEntities() {
        ArrayList<LivingEntity> ret_list = new ArrayList<LivingEntity>();
        Vec3 corner1 = this.m_20182_().m_82492_(15.0, 15.0, 15.0);
        Vec3 corner2 = this.m_20182_().m_82520_(15.0, 15.0, 15.0);
        AABB boundingBox = new AABB(corner1, corner2);
        for (LivingEntity entity : this.level().m_45976_(LivingEntity.class, boundingBox)) {
            if (this.level().m_46003_(entity.m_20148_()) != null && !((Boolean)ConfigServer.homingAtPlayers.get()).booleanValue()) continue;
            ret_list.add(entity);
        }
        return ret_list;
    }

    @Override
    public void m_8119_() {
        if (this.target == null) {
            this.findTarget();
        } else if (this.getTargetDist() > 15.0) {
            this.target = null;
        } else {
            util.addDeltaMovement(this, this.targetVector());
        }
        super.m_8119_();
    }

    @Override
    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128350_("Speed", this.getSpeed());
        super.m_7380_(pCompound);
    }

    @Override
    protected void m_7378_(CompoundTag pCompound) {
        this.setSpeed(pCompound.m_128457_("Speed"));
        super.m_7378_(pCompound);
    }

    public void setSpeed(float speed) {
        this.f_19804_.m_135381_(DATA_SPEED_ID, (Object)Float.valueOf(speed));
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(DATA_SPEED_ID)).floatValue();
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_SPEED_ID, (Object)Float.valueOf(4.0f));
        super.m_8097_();
    }

    @Override
    public void spawnParticles() {
        for (int i = 1; i <= ConfigClient.calcPCount(1); ++i) {
            this.level().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Block renderBlock() {
        return (Block)blocks.TNT_HOMING.get();
    }
}

