/*
 * Decompiled with CFR 0.152.
 */
package net.nebula.legacyroulette.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.nebula.legacyroulette.PrizeStorage;
import net.nebula.legacyroulette.RouletteRewards;
import net.nebula.legacyroulette.screen.PrizeListScreen;
import org.joml.Matrix3x2fStack;

public class RouletteScreen
extends class_437 {
    private static final int SLOT_SIZE = 40;
    private static final int VISIBLE_SLOTS = 9;
    private static final int VISIBLE_WIDTH = 360;
    private float offset = 0.0f;
    private float speed = 0.0f;
    private boolean spinning = false;
    private final List<RouletteRewards.RouletteEntry> reel = new ArrayList<RouletteRewards.RouletteEntry>();
    private float lastCenterIndex = -999.0f;
    private String winMessage = null;

    public RouletteScreen() {
        super((class_2561)class_2561.method_43470((String)"Roulette"));
    }

    protected void method_25426() {
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Spin"), btn -> this.startSpin()).method_46434(this.field_22789 / 2 - 40, this.field_22790 - 35, 80, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Prizes"), btn -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new PrizeListScreen());
            }
        }).method_46434(10, 10, 60, 20).method_46431());
        if (this.reel.isEmpty()) {
            for (int i = 0; i < 10; ++i) {
                this.reel.add(RouletteRewards.getRandomWeighted());
            }
        }
    }

    private void startSpin() {
        this.spinning = true;
        this.speed = (float)(Math.random() * 16.0) + 16.0f;
        Collections.shuffle(RouletteRewards.getDisplayList());
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        if (this.field_22787 == null) {
            return;
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int windowX = centerX - 180;
        int windowHeight = this.field_22787.method_22683().method_4495() * 12;
        int windowY = centerY - windowHeight / 2;
        ctx.method_44379(windowX, windowY, windowX + 360, windowY + windowHeight);
        if (this.spinning) {
            this.offset += this.speed * delta;
            this.speed *= (float)Math.pow(0.96f, delta);
            while (this.offset - 5.0f >= 40.0f) {
                this.offset -= 40.0f;
                if (!this.reel.isEmpty()) {
                    this.reel.removeFirst();
                }
                this.reel.add(RouletteRewards.getRandomWeighted());
            }
            float centerIdx = this.offset / 40.0f;
            if ((int)centerIdx != (int)this.lastCenterIndex) {
                if (this.field_22787.field_1724 != null) {
                    this.field_22787.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 0.6f, 1.2f);
                }
                this.lastCenterIndex = centerIdx;
            }
            if (this.speed < 0.2f) {
                this.spinning = false;
                RouletteRewards.RouletteEntry won = this.reel.get(5);
                PrizeStorage.add(won);
                this.winMessage = String.format("You won: %s", won.name());
            }
        }
        for (int i = 0; i < this.reel.size(); ++i) {
            boolean hovered;
            float drawX = (float)(windowX + i * 40) - this.offset;
            int drawY = windowY + 4;
            RouletteRewards.RouletteEntry entry = this.reel.get(i);
            Matrix3x2fStack m = ctx.method_51448();
            m.pushMatrix();
            m.translate(drawX, (float)drawY);
            ctx.method_25290(class_10799.field_56883, entry.texture(), 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            m.popMatrix();
            boolean bl = hovered = (float)mouseX >= drawX && (float)mouseX <= drawX + 16.0f && mouseY >= drawY && mouseY <= drawY + 16 && mouseX >= windowX && mouseX <= windowX + 360 && mouseY >= windowY && mouseY <= windowY + windowHeight;
            if (!hovered) continue;
            double chance = (double)entry.weight() / (double)RouletteRewards.totalWeight * 100.0;
            String chanceFormatted = String.format("%.2f%%", chance);
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43470((String)entry.name()));
            tooltip.add(class_2561.method_43470((String)("Chance: " + chanceFormatted)).method_27694(s -> s.method_36139(0xAAAAAA)));
            tooltip.add(class_2561.method_43470((String)("Rarity: " + entry.rarity())));
            ctx.method_51434(this.field_22793, tooltip, mouseX, mouseY);
        }
        ctx.method_25294(windowX + 180 - 1, windowY, windowX + 180 + 1, windowY + windowHeight, -1426063361);
        ctx.method_44380();
        if (this.winMessage != null && this.speed < 0.2f) {
            int textWidth = this.field_22787.field_1772.method_1727(this.winMessage);
            int x = (this.field_22789 - textWidth) / 2;
            int y = this.field_22790 / 3;
            ctx.method_51433(this.field_22787.field_1772, this.winMessage, x, y, -1, false);
        } else if (this.speed > 0.2f) {
            this.winMessage = null;
        }
        super.method_25394(ctx, mouseX, mouseY, delta);
    }

    public void method_25419() {
        PrizeStorage.save();
        super.method_25419();
    }
}

