/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.gui.selling;

import eu.pb4.sgui.api.elements.AnimatedGuiElement;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.universalshops.gui.BaseShopGui;
import eu.pb4.universalshops.gui.GuiBackground;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.other.USUtil;
import eu.pb4.universalshops.registry.TradeShopBlockEntity;
import eu.pb4.universalshops.trade.PriceHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class AnyStackShopGui
extends BaseShopGui {
    private int tick = 0;
    private int maxStockCount;
    private int stockCount;
    private List<BuyElement> items = new ArrayList<BuyElement>();
    private int page;
    private int lastBought;

    public AnyStackShopGui(class_3222 player, TradeShopBlockEntity blockEntity) {
        super(class_3917.field_17327, player, blockEntity, GuiBackground.TAKE_ANY);
        if (!this.hasTexture()) {
            for (int i = 0; i < 3; ++i) {
                for (int i2 = 0; i2 < 6; ++i2) {
                    this.setSlot(i + i2 * 9, (GuiElementInterface)GuiElements.FILLER);
                }
            }
        }
        if (blockEntity.isOwner((class_1657)player)) {
            this.setSlot(38, (GuiElementInterface)GuiElements.SETTINGS);
        }
        this.maxStockCount = this.be.priceHandler.getMaxAmount(this.player);
        this.stockCount = this.be.stockHandler.getMaxAmount(this.player);
        this.setMainTitle(this.getBE().getTitle());
        this.updateValueDisplays();
        this.open();
    }

    @Override
    public void onTick() {
        if (++this.tick % 20 == 0) {
            int maxStockCount = this.be.priceHandler.getMaxAmount(this.player);
            int stockCount = this.be.stockHandler.getMaxAmount(this.player);
            if (maxStockCount != this.maxStockCount || stockCount != this.stockCount) {
                this.maxStockCount = maxStockCount;
                this.stockCount = stockCount;
                this.updateValueDisplays();
            }
        }
        class_1263 inv = this.be.getContainer();
        int s = inv.method_5439();
        for (BuyElement e : this.items) {
            if (s >= e.slot && e.itemStack == inv.method_5438(e.slot)) continue;
            this.updateItems();
            break;
        }
        super.onTick();
    }

    private void updateValueDisplays() {
        class_1799 item;
        GuiElementInterface x;
        if (this.be.isOwner((class_1657)this.player)) {
            x = this.be.priceHandler.getAccessElement();
            this.setSlot(36, (GuiElementInterface)(this.hasTexture() && GuiElements.FILLER == x ? GuiElement.EMPTY : x));
        }
        x = this.be.priceHandler.getUserElement();
        this.setSlot(9, (GuiElementInterface)(this.hasTexture() && GuiElements.FILLER == x ? GuiElement.EMPTY : x));
        boolean canBuy = this.maxStockCount > 0;
        class_1799 secondStack = item = this.be.priceHandler.icon();
        if (!canBuy) {
            List tooltip;
            try {
                tooltip = item.method_7950(class_1792.class_9635.method_59528((class_1937)this.player.method_51469()), (class_1657)this.player, (class_1836)class_1836.class_1837.field_41070);
            }
            catch (Throwable e) {
                tooltip = List.of(item.method_7964());
            }
            secondStack = new GuiElementBuilder(class_1802.field_8077).setName((class_2561)tooltip.remove(0)).setLore(tooltip).asStack();
        }
        this.setSlot(10, (GuiElementInterface)new AnimatedGuiElement(new class_1799[]{item, secondStack}, 12, false, GuiElement.EMPTY_CALLBACK));
        this.setSlot(19, (GuiElementInterface)GuiElements.priceMarker(this.be.priceHandler.getText(), List.of(class_2561.method_43473(), TextUtil.gui("max_stock_left", TextUtil.number(this.maxStockCount).method_27692(class_124.field_1068)).method_27692(class_124.field_1054))));
        this.updateItems();
    }

    private void updateItems() {
        this.items.clear();
        class_1263 inv = this.be.getContainer();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            this.items.add(new BuyElement(stack, i));
        }
        this.updateItemsVisual();
    }

    private void updateItemsVisual() {
        if (this.page * 36 > this.items.size()) {
            this.page = (int)Math.ceil((double)this.items.size() / 36.0);
        }
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                int i = this.page * 36 + x + y * 6;
                this.setSlot(x + y * 9 + 3, (GuiElementInterface)(i < this.items.size() ? (GuiElementInterface)this.items.get(i) : GuiElement.EMPTY));
            }
        }
        if (this.items.size() > 36) {
            this.setSlot(45, (GuiElementInterface)GuiElements.previousPage(() -> {
                this.playClickSound();
                int pages = (int)Math.ceil((double)this.items.size() / 36.0);
                this.page = (pages + this.page - 1) % pages;
                this.updateItemsVisual();
            }));
            this.setSlot(47, (GuiElementInterface)GuiElements.nextPage(() -> {
                this.playClickSound();
                int pages = (int)Math.ceil((double)this.items.size() / 36.0);
                this.page = (this.page + 1) % pages;
                this.updateItemsVisual();
            }));
        }
    }

    private record BuyElement(class_1799 itemStack, int slot) implements GuiElementInterface
    {
        public class_1799 getItemStack() {
            return this.itemStack;
        }

        public GuiElementInterface.ClickCallback getGuiCallback() {
            return (a, clickType, c, d) -> {
                AnyStackShopGui gui = (AnyStackShopGui)d;
                boolean admin = gui.getBE().isAdmin();
                if (gui.tick == gui.lastBought) {
                    return;
                }
                gui.lastBought = gui.tick;
                if (admin || gui.getBE().getContainer().method_5438(this.slot) == this.itemStack) {
                    boolean count = USUtil.canInsert((class_1263)(clickType.shift ? USUtil.copyInventory((class_2371<class_1799>)gui.getPlayer().method_31548().method_67533()) : new class_1277(new class_1799[]{gui.getPlayer().field_7512.method_34255().method_7972()})), this.itemStack, this.itemStack.method_7947());
                    if (count) {
                        PriceHandler.Result paymentCheck = gui.be.priceHandler.payFor(gui.player, true);
                        if (paymentCheck.success()) {
                            (clickType.shift ? USUtil.addToInventory((class_2371<class_1799>)gui.player.method_31548().method_67533()) : USUtil.mergeIntoCursor(((AnyStackShopGui)gui).player.field_7512)).test(this.itemStack.method_7972());
                            if (!admin) {
                                this.itemStack.method_7939(0);
                                gui.be.getContainer().method_5447(this.slot, class_1799.field_8037);
                            }
                            gui.playClickSound();
                            gui.updateValueDisplays();
                            gui.markDirty();
                        } else {
                            gui.playDismissSound();
                            gui.player.method_64398(TextUtil.prefix((class_2561)class_2561.method_43473().method_10852(paymentCheck.failureMessage()).method_27692(class_124.field_1061)));
                            gui.setTempTitle((class_2561)class_2561.method_43473().method_10852(paymentCheck.failureMessage()).method_27692(class_124.field_1079));
                        }
                    } else {
                        class_5250 text = TextUtil.text(clickType.shift ? "not_enough_inventory_space" : "not_enough_stack_space", new Object[0]);
                        gui.player.method_64398(TextUtil.prefix((class_2561)text.method_27661().method_27692(class_124.field_1061)));
                        gui.setTempTitle((class_2561)text.method_27692(class_124.field_1079));
                        gui.playDismissSound();
                    }
                }
            };
        }
    }
}

