/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.gui.selling;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.AnimatedGuiElement;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.universalshops.gui.BaseShopGui;
import eu.pb4.universalshops.gui.GuiBackground;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.registry.TradeShopBlockEntity;
import eu.pb4.universalshops.trade.StockHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;

public abstract class SingleGenericShopGui
extends BaseShopGui {
    private int tick = 0;
    private int maxStockCount;
    private int stockCount;

    public SingleGenericShopGui(class_3222 player, TradeShopBlockEntity blockEntity) {
        super(class_3917.field_17326, player, blockEntity, GuiBackground.SINGLE_ITEM);
        if (!this.hasTexture()) {
            for (int i = 0; i < this.getSize(); ++i) {
                this.setSlot(i, (GuiElementInterface)GuiElements.FILLER);
            }
        }
        if (blockEntity.isOwner((class_1657)player)) {
            this.setSlot(26, (GuiElementInterface)GuiElements.SETTINGS);
        }
        this.maxStockCount = this.be.priceHandler.getMaxAmount(this.player);
        this.stockCount = this.be.stockHandler.getMaxAmount(player);
        this.setMainTitle(blockEntity.getTitle());
        this.updateValueDisplays();
        this.open();
    }

    @Override
    public void onTick() {
        if (++this.tick % 20 == 0) {
            int maxStockCount = this.be.priceHandler.getMaxAmount(this.player);
            int stockCount = this.be.stockHandler.getMaxAmount(this.player);
            if (maxStockCount != this.maxStockCount || stockCount != this.stockCount) {
                this.maxStockCount = maxStockCount;
                this.stockCount = stockCount;
                this.updateValueDisplays();
            }
        }
        super.onTick();
    }

    protected void updateValueDisplays() {
        class_1799 item;
        class_1799 item2;
        GuiElementInterface x;
        if (this.be.isOwner((class_1657)this.player)) {
            x = this.be.priceHandler.getAccessElement();
            this.setSlot(18, (GuiElementInterface)(this.hasTexture() && GuiElements.FILLER == x ? GuiElement.EMPTY : x));
        }
        x = this.be.priceHandler.getUserElement();
        this.setSlot(2, (GuiElementInterface)(this.hasTexture() && GuiElements.FILLER == x ? GuiElement.EMPTY : x));
        boolean canBuy = this.maxStockCount > 0;
        class_1799 secondStack = item2 = this.be.priceHandler.icon();
        if (!canBuy) {
            List tooltip;
            try {
                tooltip = item2.method_7950(class_1792.class_9635.method_59528((class_1937)this.player.method_51469()), (class_1657)this.player, (class_1836)class_1836.class_1837.field_41070);
            }
            catch (Throwable e) {
                tooltip = List.of(item2.method_7964());
            }
            secondStack = new GuiElementBuilder(class_1802.field_8077).setName((class_2561)tooltip.remove(0)).setLore(tooltip).asStack();
        }
        this.setSlot(11, (GuiElementInterface)new AnimatedGuiElement(new class_1799[]{item2, secondStack}, 12, false, GuiElement.EMPTY_CALLBACK));
        this.setSlot(20, (GuiElementInterface)GuiElements.priceMarker(this.be.priceHandler.getText(), List.of(class_2561.method_43473(), TextUtil.gui("max_stock_left", TextUtil.number(this.maxStockCount).method_27692(class_124.field_1068)).method_27692(class_124.field_1054))));
        StockHandler stock = this.be.stockHandler;
        boolean hasStock = this.stockCount > 0;
        class_1799 secondStack2 = item = stock.icon();
        if (!hasStock) {
            List tooltip;
            try {
                tooltip = item.method_7950(class_1792.class_9635.method_59528((class_1937)this.player.method_51469()), (class_1657)this.player, (class_1836)class_1836.class_1837.field_41070);
            }
            catch (Throwable e) {
                tooltip = new ArrayList<class_2561>();
                tooltip.add(item.method_7964());
            }
            secondStack2 = new GuiElementBuilder(class_1802.field_8077).setName((class_2561)tooltip.remove(0)).setLore(tooltip).asStack();
        }
        this.setSlot(15, (GuiElementInterface)new AnimatedGuiElement(new class_1799[]{stock.icon(), secondStack2}, 12, false, this::buyItem));
        this.setSlot(24, (GuiElementInterface)GuiElements.itemMarker(this.getMainText(), List.of(class_2561.method_43473(), TextUtil.gui("stock_left", TextUtil.number(this.stockCount).method_27692(class_124.field_1068)).method_27692(class_124.field_1054), class_2561.method_43473(), hasStock ? TextUtil.gui("click_to_buy", new Object[0]).method_27692(class_124.field_1060) : TextUtil.gui("out_of_stock", new Object[0]).method_27692(class_124.field_1061))));
    }

    protected abstract class_2561 getMainText();

    protected abstract void buyItem(int var1, ClickType var2, class_1713 var3);

    @Override
    public TradeShopBlockEntity getBE() {
        return this.be;
    }
}

