/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.milkme;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import one.crafters.milkme.commands.MilkmeCommandExecutor;
import one.crafters.milkme.utils.MetricsLite;
import one.crafters.milkme.utils.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class Milkme
extends JavaPlugin
implements Listener {
    Boolean debug = false;
    private boolean eventsRegistered = false;
    private static Milkme instance;
    private File userDataFile;
    private FileConfiguration userDataConfig;
    private Map<Player, Long> cooldowns = new HashMap<Player, Long>();
    String getprefix = this.getConfig().getString("prefix");
    String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.getprefix + " "));
    private long cooldownDuration = 0L;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.checkAndAddDefaultConfigValues();
        this.saveConfigWithComments();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("milkme").setExecutor((CommandExecutor)new MilkmeCommandExecutor(this));
        int pluginId = 21835;
        MetricsLite metrics = new MetricsLite(this, pluginId);
        this.userDataFile = new File(this.getDataFolder(), "userdata.yml");
        this.reloadUserDataConfig();
        this.updateCooldownDuration();
        new UpdateChecker(this, 116697).getLatestVersion(version -> {
            String currentversion = this.getDescription().getVersion();
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                instance.getLogger().info("Plugin is running the latest version! (" + version + ")");
            } else {
                instance.getLogger().info("--------------------");
                instance.getLogger().info("Your version (" + currentversion + ") is outdated! Please download the latest version (" + version + ")");
                instance.getLogger().info("https://testers.one/plugins/milkme/latest/");
                instance.getLogger().info("--------------------");
            }
        });
    }

    public void checkAndAddDefaultConfigValues() {
        FileConfiguration config = this.getConfig();
        if (!config.contains("milked-moo-sound")) {
            config.set("milked-moo-sound", (Object)true);
        }
        if (!config.contains("milked-hurt-sound")) {
            config.set("milked-hurt-sound", (Object)true);
        }
        if (!config.contains("milked-sound-vol")) {
            config.set("milked-sound-vol", (Object)1.0);
        }
        if (!config.contains("use-permission")) {
            config.set("use-permission", (Object)false);
        }
        this.saveConfig();
    }

    public void saveConfigWithComments() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        try {
            if (!configFile.exists()) {
                configFile.createNewFile();
            }
            FileConfiguration config = this.getConfig();
            config.save(configFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save config to " + configFile);
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().isOp()) {
            new UpdateChecker(this, 116697).getLatestVersion(version -> {
                String currentVersion = this.getDescription().getVersion();
                if (!currentVersion.equalsIgnoreCase((String)version)) {
                    event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)""));
                    event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&fPlugin outdated!")));
                    event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7https://testers.one/plugins/milkme/latest/"));
                    event.getPlayer().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)""));
                }
            });
        }
    }

    public void updateCooldownDuration() {
        String cooldownString = this.getConfig().getString("cool-down");
        long cooldownDuration = this.parseCooldown(cooldownString);
        this.setCooldownDuration(cooldownDuration);
    }

    public long parseCooldown(String cooldownString) {
        try {
            if (cooldownString.endsWith("s")) {
                String numericString = cooldownString.substring(0, cooldownString.length() - 1);
                return Long.parseLong(numericString);
            }
            return Long.parseLong(cooldownString);
        }
        catch (NumberFormatException e) {
            this.getLogger().warning("Invalid cooldown duration specified in config: " + cooldownString);
            return 0L;
        }
    }

    private void setCooldownDuration(long duration) {
        this.cooldownDuration = duration;
    }

    private long getCooldownDuration() {
        return this.cooldownDuration;
    }

    public void onDisable() {
    }

    @EventHandler
    public void onPlayerRightClickEntity(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        FileConfiguration config = this.getConfig();
        boolean usePermissionEnabled = config.getBoolean("use-permission", true);
        boolean milkedMooSoundEnabled = config.getBoolean("milked-moo-sound", true);
        boolean milkedHurtSoundEnabled = config.getBoolean("milked-hurt-sound", true);
        float milkedSoundVolume = (float)config.getDouble("milked-sound-vol", 1.0);
        final Player clickedPlayer = (Player)event.getRightClicked();
        Player player = event.getPlayer();
        if (event.getHand() == EquipmentSlot.OFF_HAND && event.getHand() != null) {
            return;
        }
        if (usePermissionEnabled && !player.hasPermission("milkme.use")) {
            return;
        }
        if (this.debug.booleanValue()) {
            this.getLogger().info("Player " + player.getName() + " interacted with " + clickedPlayer.getName());
        }
        if (!this.isMilkable(clickedPlayer.getUniqueId())) {
            return;
        }
        if (!this.hasBucketCooldown(player) && player.getInventory().getItemInMainHand().getType() == Material.BUCKET) {
            event.setCancelled(true);
            ItemStack bucket = new ItemStack(Material.BUCKET);
            ItemStack milkBucket = new ItemStack(Material.MILK_BUCKET);
            if (player.getInventory().containsAtLeast(bucket, 1)) {
                player.getInventory().removeItem(new ItemStack[]{bucket});
                HashMap remainingItems = player.getInventory().addItem(new ItemStack[]{milkBucket});
                if (!remainingItems.isEmpty()) {
                    for (ItemStack item : remainingItems.values()) {
                        player.getWorld().dropItemNaturally(player.getLocation(), item);
                    }
                }
                player.updateInventory();
            } else {
                player.getWorld().dropItemNaturally(player.getLocation(), milkBucket);
            }
            if (milkedMooSoundEnabled) {
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_COW_MILK, milkedSoundVolume, 1.0f);
            }
            if (milkedHurtSoundEnabled) {
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_COW_HURT, milkedSoundVolume, 1.0f);
            }
            double damage = instance.getConfig().getDouble("damage", 0.0);
            clickedPlayer.damage(damage);
            clickedPlayer.setMetadata("milking", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            new BukkitRunnable(){

                public void run() {
                    if (clickedPlayer != null && clickedPlayer.hasMetadata("milking")) {
                        clickedPlayer.removeMetadata("milking", (Plugin)instance);
                        if (Milkme.this.debug.booleanValue()) {
                            Milkme.this.getLogger().info("Metadata removed from " + clickedPlayer.getName());
                        }
                    }
                }
            }.runTaskLater((Plugin)this, 100L);
            if (this.getCooldownDuration() != 0L) {
                this.applyBucketCooldown(player);
            }
            if (this.debug.booleanValue()) {
                this.getLogger().info("Bucket cooldown applied to " + player.getName());
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (player.hasMetadata("milking")) {
            String deathmessage = this.getConfig().getString("death-message");
            event.setDeathMessage(deathmessage.replace("{PLAYER}", player.getName()));
            player.removeMetadata("milking", (Plugin)this);
        }
    }

    private boolean hasBucketCooldown(Player player) {
        long cooldownDuration = this.getCooldownDuration();
        if (cooldownDuration == 0L) {
            return false;
        }
        return this.cooldowns.containsKey(player) && System.currentTimeMillis() - this.cooldowns.get(player) < cooldownDuration * 1000L;
    }

    private void applyBucketCooldown(Player player) {
        this.cooldowns.put(player, System.currentTimeMillis());
    }

    public void addMilkablePlayer(UUID playerUUID) {
        List<String> milkablePlayers = this.getMilkablePlayers();
        if (!milkablePlayers.contains(playerUUID.toString())) {
            milkablePlayers.add(playerUUID.toString());
            this.saveMilkablePlayers(milkablePlayers);
        }
    }

    public String removeMilkablePlayer(UUID playerUUID) {
        List<String> milkablePlayers = this.getMilkablePlayers();
        if (milkablePlayers.contains(playerUUID.toString())) {
            milkablePlayers.remove(playerUUID.toString());
            this.saveMilkablePlayers(milkablePlayers);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&f" + Bukkit.getOfflinePlayer((UUID)playerUUID).getName() + " is no longer milkable."));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(this.prefix + "&f" + Bukkit.getOfflinePlayer((UUID)playerUUID).getName() + " is not milkable."));
    }

    public boolean isMilkable(UUID playerUUID) {
        List<String> milkablePlayers = this.getMilkablePlayers();
        return milkablePlayers.contains(playerUUID.toString());
    }

    public List<String> getMilkablePlayers() {
        return this.userDataConfig.getStringList("milkable-players");
    }

    public void saveMilkablePlayers(List<String> milkablePlayers) {
        this.userDataConfig.set("milkable-players", milkablePlayers);
        this.saveUserDataConfig();
    }

    public void reloadUserDataConfig() {
        if (this.userDataFile == null) {
            this.userDataFile = new File(this.getDataFolder(), "userdata.yml");
        }
        if (!this.userDataFile.exists()) {
            try {
                this.userDataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.userDataConfig = YamlConfiguration.loadConfiguration((File)this.userDataFile);
    }

    public void saveUserDataConfig() {
        if (this.userDataConfig == null || this.userDataFile == null) {
            return;
        }
        try {
            this.userDataConfig.save(this.userDataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

