/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.milkme.commands;

import java.util.ArrayList;
import java.util.UUID;
import one.crafters.milkme.Milkme;
import one.crafters.milkme.utils.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class MilkmeCommandExecutor
implements CommandExecutor,
Listener {
    private final Milkme plugin;
    private final int PLAYERS_PER_PAGE = 45;

    public MilkmeCommandExecutor(Milkme plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be executed by players.");
            return true;
        }
        Player player = (Player)sender;
        String getprefix = this.plugin.getConfig().getString("prefix");
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)(getprefix + " "));
        if (!player.hasPermission("milkme.admin")) {
            return true;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("manage")) {
            this.openManageGUI(player);
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            this.plugin.reloadConfig();
            this.plugin.reloadUserDataConfig();
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fConfiguration reloaded.")));
            this.plugin.updateCooldownDuration();
            player.closeInventory();
            new UpdateChecker(this.plugin, 116697).getLatestVersion(version -> {
                String currentVersion = this.plugin.getDescription().getVersion();
                if (!currentVersion.equalsIgnoreCase((String)version)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)""));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fPlugin &coutdated&f!")));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7https://testers.one/plugins/milkme/latest/"));
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)""));
                }
            });
            return true;
        }
        if (args.length < 2) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fUsage: /milkme add <player> | /milkme remove <player> | /milkme manage")));
            return true;
        }
        String action = args[0].toLowerCase();
        String playerName = args[1];
        OfflinePlayer targetPlayer = Bukkit.getOfflinePlayer((String)playerName);
        UUID playerUUID = targetPlayer.getUniqueId();
        if (targetPlayer == null || !targetPlayer.hasPlayedBefore()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fUnknown player.")));
            return true;
        }
        if (action.equals("add")) {
            if (this.plugin.isMilkable(playerUUID)) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fPlayer already milkable.")));
            } else {
                this.plugin.addMilkablePlayer(playerUUID);
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&f" + targetPlayer.getName() + " &fis now milkable.")));
            }
        } else if (action.equals("remove")) {
            if (!this.plugin.isMilkable(playerUUID)) {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fPlayer is not milkable.")));
            } else {
                String message = this.plugin.removeMilkablePlayer(playerUUID);
                player.sendMessage(message);
            }
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&fInvalid action. Usage: /milkme add <player> | /milkme remove <player>")));
        }
        return true;
    }

    private void openManageGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)("MilkMe Manager | v." + this.plugin.getDescription().getVersion()));
        ItemStack damageItem = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta damageMeta = damageItem.getItemMeta();
        damageMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eDamage"));
        ArrayList<String> damageLore = new ArrayList<String>();
        damageLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Current: &c\u2764 " + this.plugin.getConfig().getDouble("damage") / 2.0)));
        damageLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f"));
        damageLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Left click +0.5"));
        damageLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Right click -0.5"));
        damageMeta.setLore(damageLore);
        damageItem.setItemMeta(damageMeta);
        ItemStack cooldownItem = new ItemStack(Material.CLOCK);
        ItemMeta cooldownMeta = cooldownItem.getItemMeta();
        cooldownMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eCooldown"));
        ArrayList<String> cooldownLore = new ArrayList<String>();
        cooldownLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7Current: " + this.plugin.getConfig().getString("cool-down"))));
        cooldownLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f"));
        cooldownLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Left click +1 second"));
        cooldownLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Right click -1 second"));
        cooldownMeta.setLore(cooldownLore);
        cooldownItem.setItemMeta(cooldownMeta);
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta playerHeadMeta = playerHead.getItemMeta();
        playerHeadMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eManage Players"));
        ArrayList<String> playerheadLore = new ArrayList<String>();
        playerheadLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Click to manage a list of online players."));
        playerHeadMeta.setLore(playerheadLore);
        playerHead.setItemMeta(playerHeadMeta);
        ItemStack exitItem = new ItemStack(Material.BARRIER);
        ItemMeta exitMeta = exitItem.getItemMeta();
        exitMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cExit Menu"));
        exitMeta.setLore(new ArrayList());
        exitItem.setItemMeta(exitMeta);
        ItemStack reloadConfigItem = new ItemStack(Material.PAPER);
        ItemMeta reloadConfigMeta = reloadConfigItem.getItemMeta();
        reloadConfigMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eReload config"));
        reloadConfigItem.setItemMeta(reloadConfigMeta);
        gui.setItem(11, damageItem);
        gui.setItem(13, playerHead);
        gui.setItem(15, cooldownItem);
        gui.setItem(26, exitItem);
        gui.setItem(25, reloadConfigItem);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!event.getView().getTitle().startsWith("MilkMe Manager")) {
            return;
        }
        event.setCancelled(true);
        FileConfiguration config = this.plugin.getConfig();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (clickedItem.getType() == Material.NETHERITE_SWORD && clickedItem.getItemMeta().getDisplayName().contains("Damage")) {
            double damage = config.getDouble("damage");
            if (event.isLeftClick()) {
                damage += 0.5;
            } else if (event.isRightClick()) {
                damage -= 0.5;
            }
            if (damage < 0.0) {
                damage = 0.0;
            }
            this.plugin.getConfig().set("damage", (Object)damage);
            this.plugin.saveConfigWithComments();
            this.plugin.reloadConfig();
            this.openManageGUI(player);
        } else if (clickedItem.getType() == Material.CLOCK && clickedItem.getItemMeta().getDisplayName().contains("Cooldown")) {
            String cooldownString = config.getString("cool-down");
            long cooldown = this.plugin.parseCooldown(cooldownString);
            if (event.isLeftClick()) {
                ++cooldown;
            } else if (event.isRightClick()) {
                --cooldown;
            }
            if (cooldown < 0L) {
                cooldown = 0L;
            }
            this.plugin.getConfig().set("cool-down", (Object)(cooldown + "s"));
            this.plugin.saveConfigWithComments();
            this.plugin.reloadConfig();
            this.plugin.updateCooldownDuration();
            this.openManageGUI(player);
        } else if (clickedItem.getType() == Material.PLAYER_HEAD && clickedItem.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eManage Players"))) {
            this.openPlayerManageGUI(player, 0);
        } else if (clickedItem.getType() == Material.BARRIER && clickedItem.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cExit Menu"))) {
            player.closeInventory();
        } else if (clickedItem.getType() == Material.PAPER && clickedItem.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eReload config"))) {
            this.plugin.reloadConfig();
            this.plugin.reloadUserDataConfig();
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(this.plugin.getConfig().getString("prefix") + " &fConfiguration reloaded.")));
            this.plugin.updateCooldownDuration();
            player.closeInventory();
        }
    }

    private void openPlayerManageGUI(Player player, int page) {
        ArrayList onlinePlayers = new ArrayList(Bukkit.getOnlinePlayers());
        int totalPlayers = onlinePlayers.size();
        int totalPages = (int)Math.ceil((double)totalPlayers / 45.0);
        if (page < 0 || page >= totalPages) {
            return;
        }
        int size = 54;
        Inventory playerGui = Bukkit.createInventory(null, (int)size, (String)("Manage Players | Page " + (page + 1)));
        int startIndex = page * 45;
        int endIndex = Math.min(startIndex + 45, totalPlayers);
        for (int i = startIndex; i < endIndex; ++i) {
            Player onlinePlayer = (Player)onlinePlayers.get(i);
            ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta playerHeadMeta = (SkullMeta)playerHead.getItemMeta();
            try {
                playerHeadMeta.setOwningPlayer((OfflinePlayer)onlinePlayer);
            }
            catch (Exception e) {
                playerHeadMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)"MHF_Steve"));
            }
            playerHeadMeta.setDisplayName(ChatColor.YELLOW + ChatColor.stripColor((String)onlinePlayer.getName()));
            ArrayList<String> lore = new ArrayList<String>();
            if (this.plugin.isMilkable(onlinePlayer.getUniqueId())) {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Milkable Status: &aEnabled"));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7"));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8Click to disable"));
            } else {
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Milkable Status: &cDisabled"));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7"));
                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8Click to enable"));
            }
            playerHeadMeta.setLore(lore);
            playerHead.setItemMeta((ItemMeta)playerHeadMeta);
            playerGui.addItem(new ItemStack[]{playerHead});
        }
        if (page > 0) {
            playerGui.setItem(45, this.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTMzYWQ1YzIyZGIxNjQzNWRhYWQ2MTU5MGFiYTUxZDkzNzkxNDJkZDU1NmQ2YzQyMmE3MTEwY2EzYWJlYTUwIn19fQ==", ChatColor.translateAlternateColorCodes((char)'&', (String)"&e<-- Previous page")));
        }
        if (page < totalPages - 1) {
            playerGui.setItem(53, this.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGU0MDNjYzdiYmFjNzM2NzBiZDU0M2Y2YjA5NTViYWU3YjhlOTEyM2Q4M2JkNzYwZjYyMDRjNWFmZDhiZTdlMSJ9fX0=", ChatColor.translateAlternateColorCodes((char)'&', (String)"&eNext page -->")));
        }
        ItemStack backButton = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = backButton.getItemMeta();
        backMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cBack"));
        backButton.setItemMeta(backMeta);
        playerGui.setItem(49, backButton);
        player.openInventory(playerGui);
    }

    private ItemStack createCustomHead(String texture, String displayName) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        OfflinePlayer steve = Bukkit.getOfflinePlayer((String)"MHF_Steve");
        meta.setOwningPlayer(steve);
        meta.setDisplayName(displayName);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @EventHandler
    public void onPlayerManageClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String getprefix = this.plugin.getConfig().getString("prefix");
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)(getprefix + " "));
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        if (!title.startsWith("Manage Players")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        String[] titleParts = title.split(" ");
        int currentPage = Integer.parseInt(titleParts[titleParts.length - 1]) - 1;
        if (clickedItem.getType() == Material.PLAYER_HEAD) {
            String displayName = clickedItem.getItemMeta().getDisplayName();
            if (displayName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&eNext page -->"))) {
                this.openPlayerManageGUI(player, currentPage + 1);
            } else if (displayName.equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&e<-- Previous page"))) {
                this.openPlayerManageGUI(player, currentPage - 1);
            } else {
                String clickedPlayerName = ChatColor.stripColor((String)displayName);
                OfflinePlayer clickedPlayer = Bukkit.getOfflinePlayer((String)clickedPlayerName);
                UUID clickedPlayerUUID = clickedPlayer.getUniqueId();
                if (this.plugin.isMilkable(clickedPlayerUUID)) {
                    this.plugin.removeMilkablePlayer(clickedPlayerUUID);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&f" + clickedPlayerName + " is no longer milkable.")));
                } else {
                    this.plugin.addMilkablePlayer(clickedPlayerUUID);
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&f" + clickedPlayerName + " is now milkable.")));
                }
                this.openPlayerManageGUI(player, currentPage);
            }
        } else if (clickedItem.getType() == Material.BARRIER && clickedItem.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)"&cBack"))) {
            this.openManageGUI(player);
        }
    }
}

