/*
 * Decompiled with CFR 0.152.
 */
package one.crafters.milkme.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigUtil {
    public static void saveConfigWithComments(File configFile, FileConfiguration config, Logger logger) {
        try {
            File backupFile = new File(configFile.getParent(), configFile.getName() + ".backup");
            Files.copy(configFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            config.save(configFile);
            String originalContent = new String(Files.readAllBytes(backupFile.toPath()));
            String updatedContent = new String(Files.readAllBytes(configFile.toPath()));
            String mergedContent = ConfigUtil.mergeComments(originalContent, updatedContent);
            Files.write(configFile.toPath(), mergedContent.getBytes(), new OpenOption[0]);
            backupFile.delete();
        }
        catch (IOException e) {
            logger.severe("Failed to save config with comments: " + e.getMessage());
        }
    }

    private static String mergeComments(String originalContent, String updatedContent) {
        String[] originalLines = originalContent.split("\n");
        String[] updatedLines = updatedContent.split("\n");
        StringBuilder mergedContent = new StringBuilder();
        block0: for (String originalLine : originalLines) {
            if (originalLine.trim().startsWith("#") || originalLine.trim().isEmpty()) {
                mergedContent.append(originalLine).append("\n");
                continue;
            }
            for (String updatedLine : updatedLines) {
                if (!updatedLine.trim().startsWith(originalLine.trim().split(":")[0])) continue;
                mergedContent.append(updatedLine).append("\n");
                continue block0;
            }
        }
        return mergedContent.toString();
    }
}

