/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tn.naizo.remnants.client.model.Modelskeleton_ninja;
import tn.naizo.remnants.client.model.animations.skeleton_ninjaAnimation;
import tn.naizo.remnants.entity.RemnantOssukageEntity;
import tn.naizo.remnants.procedures.SkeletonNinjaDisplayConditionProcedure;

public class RemnantOssukageRenderer
extends MobRenderer<RemnantOssukageEntity, Modelskeleton_ninja<RemnantOssukageEntity>> {
    public RemnantOssukageRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelskeleton_ninja.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<RemnantOssukageEntity, Modelskeleton_ninja<RemnantOssukageEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"remnant_bosses:textures/entities/ninja_dead.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RemnantOssukageEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                ((Modelskeleton_ninja)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<RemnantOssukageEntity, Modelskeleton_ninja<RemnantOssukageEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"remnant_bosses:textures/entities/ninja_skeleton_orignal.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, RemnantOssukageEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (SkeletonNinjaDisplayConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelskeleton_ninja)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(RemnantOssukageEntity entity) {
        return ResourceLocation.parse((String)("remnant_bosses:textures/entities/" + entity.getTexture() + ".png"));
    }

    private static final class AnimatedModel
    extends Modelskeleton_ninja<RemnantOssukageEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<RemnantOssukageEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(RemnantOssukageEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, skeleton_ninjaAnimation.idle, ageInTicks, 1.0f);
                this.animateWalk(skeleton_ninjaAnimation.walk, limbSwing, limbSwingAmount, 1.0f, 1.0f);
                this.animate(entity.animationState2, skeleton_ninjaAnimation.attack, ageInTicks, 1.0f);
                this.animate(entity.animationState3, skeleton_ninjaAnimation.death, ageInTicks, 1.0f);
                this.animate(entity.animationState4, skeleton_ninjaAnimation.leap_attack, ageInTicks, 1.0f);
                this.animate(entity.animationState5, skeleton_ninjaAnimation.spawn, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(RemnantOssukageEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

