/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.item;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import tn.naizo.remnants.init.RemnantBossesModItems;
import tn.naizo.remnants.procedures.OssukageSwordLivingEntityIsHitWithToolProcedure;
import tn.naizo.remnants.procedures.OssukageSwordRightclickedProcedure;
import tn.naizo.remnants.procedures.OssukageSwordToolInHandTickProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class OssukageSwordItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 0;
        }

        public float getSpeed() {
            return 15.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_WOODEN_TOOL;
        }

        public int getEnchantmentValue() {
            return 2;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)RemnantBossesModItems.OLD_SKELETON_BONE.get())});
        }
    };

    public OssukageSwordItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)11.0f, (float)-2.0f)).fireResistant());
    }

    @SubscribeEvent
    public static void handleToolDamage(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)RemnantBossesModItems.OSSUKAGE_SWORD.get(), builder -> builder.remove(DataComponents.MAX_DAMAGE));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        OssukageSwordLivingEntityIsHitWithToolProcedure.execute((Entity)entity);
        return retval;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        OssukageSwordRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity);
        return ar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_0"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_1"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_2"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_3"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_4"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_5"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_6"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_7"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_8"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_9"));
        list.add((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_10"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            OssukageSwordToolInHandTickProcedure.execute(entity);
        }
    }
}

