/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import tn.naizo.remnants.client.model.Modelrat;
import tn.naizo.remnants.client.model.animations.ratAnimation;
import tn.naizo.remnants.entity.RatEntity;
import tn.naizo.remnants.procedures.RatDisplayCondition2Procedure;
import tn.naizo.remnants.procedures.RatDisplayCondition3Procedure;
import tn.naizo.remnants.procedures.RatDisplayCondition4Procedure;
import tn.naizo.remnants.procedures.RatDisplayConditionProcedure;

public class RatRenderer
extends MobRenderer<RatEntity, LivingEntityRenderState, Modelrat> {
    private RatEntity entity = null;

    public RatRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelrat.LAYER_LOCATION)), 0.5f);
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelrat>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"remnant_bosses:textures/entities/rat.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = RatRenderer.this.entity.level();
                double x = RatRenderer.this.entity.getX();
                double y = RatRenderer.this.entity.getY();
                double z = RatRenderer.this.entity.getZ();
                if (RatDisplayConditionProcedure.execute((Entity)RatRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelrat)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelrat>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"remnant_bosses:textures/entities/rat_blue.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = RatRenderer.this.entity.level();
                double x = RatRenderer.this.entity.getX();
                double y = RatRenderer.this.entity.getY();
                double z = RatRenderer.this.entity.getZ();
                if (RatDisplayCondition2Procedure.execute((Entity)RatRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelrat)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelrat>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"remnant_bosses:textures/entities/rat_grey.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = RatRenderer.this.entity.level();
                double x = RatRenderer.this.entity.getX();
                double y = RatRenderer.this.entity.getY();
                double z = RatRenderer.this.entity.getZ();
                if (RatDisplayCondition3Procedure.execute((Entity)RatRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelrat)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<LivingEntityRenderState, Modelrat>((RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE;
            {
                this.LAYER_TEXTURE = ResourceLocation.parse((String)"remnant_bosses:textures/entities/rat_yellow.png");
            }

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, LivingEntityRenderState state, float headYaw, float headPitch) {
                Level world = RatRenderer.this.entity.level();
                double x = RatRenderer.this.entity.getX();
                double y = RatRenderer.this.entity.getY();
                double z = RatRenderer.this.entity.getZ();
                if (RatDisplayCondition4Procedure.execute((Entity)RatRenderer.this.entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelrat)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
                }
            }
        });
    }

    public LivingEntityRenderState createRenderState() {
        return new LivingEntityRenderState();
    }

    public void extractRenderState(RatEntity entity, LivingEntityRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, state, partialTicks);
        this.entity = entity;
        if (this.model instanceof AnimatedModel) {
            ((AnimatedModel)this.model).setEntity(entity);
        }
    }

    public ResourceLocation getTextureLocation(LivingEntityRenderState state) {
        return ResourceLocation.parse((String)"remnant_bosses:textures/entities/rat.png");
    }

    private static final class AnimatedModel
    extends Modelrat {
        private RatEntity entity = null;

        public AnimatedModel(ModelPart root) {
            super(root);
        }

        public void setEntity(RatEntity entity) {
            this.entity = entity;
        }

        @Override
        public void setupAnim(LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.animate(this.entity.animationState0, ratAnimation.idle, state.ageInTicks, 1.0f);
            this.animateWalk(ratAnimation.walk, state.walkAnimationPos, state.walkAnimationSpeed, 1.0f, 1.0f);
            this.animate(this.entity.animationState2, ratAnimation.attack, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }
    }
}

