/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import tn.naizo.remnants.entity.KunaiEntity;
import tn.naizo.remnants.entity.RatEntity;
import tn.naizo.remnants.entity.RemnantOssukageEntity;
import tn.naizo.remnants.entity.SkeletonMinionEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class RemnantBossesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"remnant_bosses");
    public static final DeferredHolder<EntityType<?>, EntityType<KunaiEntity>> KUNAI = RemnantBossesModEntities.register("kunai", EntityType.Builder.of(KunaiEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<RatEntity>> RAT = RemnantBossesModEntities.register("rat", EntityType.Builder.of(RatEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.2f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SkeletonMinionEntity>> SKELETON_MINION = RemnantBossesModEntities.register("skeleton_minion", EntityType.Builder.of(SkeletonMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RemnantOssukageEntity>> REMNANT_OSSUKAGE = RemnantBossesModEntities.register("remnant_ossukage", EntityType.Builder.of(RemnantOssukageEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).sized(0.8f, 2.4f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"remnant_bosses", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        RatEntity.init(event);
        SkeletonMinionEntity.init(event);
        RemnantOssukageEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)RAT.get(), RatEntity.createAttributes().build());
        event.put((EntityType)SKELETON_MINION.get(), SkeletonMinionEntity.createAttributes().build());
        event.put((EntityType)REMNANT_OSSUKAGE.get(), RemnantOssukageEntity.createAttributes().build());
    }
}

