/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.item;

import java.util.function.Consumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import tn.naizo.remnants.init.RemnantBossesModItems;
import tn.naizo.remnants.procedures.OssukageSwordLivingEntityIsHitWithToolProcedure;
import tn.naizo.remnants.procedures.OssukageSwordRightclickedProcedure;
import tn.naizo.remnants.procedures.OssukageSwordToolInHandTickProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class OssukageSwordItem
extends Item {
    private static final ToolMaterial TOOL_MATERIAL = new ToolMaterial(BlockTags.INCORRECT_FOR_WOODEN_TOOL, 0, 15.0f, 0.0f, 2, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"remnant_bosses:ossukage_sword_repair_items")));

    public OssukageSwordItem(Item.Properties properties) {
        super(properties.sword(TOOL_MATERIAL, 11.0f, -2.0f).fireResistant());
    }

    @SubscribeEvent
    public static void handleToolDamage(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)RemnantBossesModItems.OSSUKAGE_SWORD.get(), builder -> builder.remove(DataComponents.MAX_DAMAGE));
    }

    public void hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        super.hurtEnemy(itemstack, entity, sourceentity);
        OssukageSwordLivingEntityIsHitWithToolProcedure.execute((Entity)entity);
    }

    public InteractionResult use(Level world, Player entity, InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        OssukageSwordRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity);
        return ar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, display, list, flag);
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_0"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_1"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_2"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_3"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_4"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_5"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_6"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_7"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_8"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_9"));
        list.accept((Component)Component.translatable((String)"item.remnant_bosses.ossukage_sword.description_10"));
    }

    public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
        super.inventoryTick(itemstack, world, entity, slot);
        OssukageSwordToolInHandTickProcedure.execute(entity);
    }
}

