/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import tn.naizo.remnants.init.RemnantBossesModEntities;
import tn.naizo.remnants.init.RemnantBossesModItems;
import tn.naizo.remnants.procedures.NinjaSkeletonEntityIsHurtProcedure;
import tn.naizo.remnants.procedures.NinjaSkeletonOnEntityTickUpdateProcedure;
import tn.naizo.remnants.procedures.OssukageEntityDiesProcedure;
import tn.naizo.remnants.procedures.OssukageOnInitialEntitySpawnProcedure;

public class RemnantOssukageEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_transform = SynchedEntityData.m_135353_(RemnantOssukageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_AI = SynchedEntityData.m_135353_(RemnantOssukageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> DATA_state = SynchedEntityData.m_135353_(RemnantOssukageEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.PROGRESS);

    public RemnantOssukageEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RemnantOssukageEntity>)((EntityType)RemnantBossesModEntities.REMNANT_OSSUKAGE.get()), world);
    }

    public RemnantOssukageEntity(EntityType<RemnantOssukageEntity> type, Level world) {
        super(type, world);
        this.f_19793_ = 0.6f;
        this.f_21364_ = 0;
        this.m_21557_(false);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_transform, (Object)false);
        this.f_19804_.m_135372_(DATA_AI, (Object)0);
        this.f_19804_.m_135372_(DATA_state, (Object)"");
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)RemnantBossesModItems.OSSUKAGE_SWORD.get()));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.f_19853_;
        RemnantOssukageEntity entity = this;
        Entity sourceentity = damagesource.m_7639_();
        Entity immediatesourceentity = damagesource.m_7640_();
        NinjaSkeletonEntityIsHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return super.m_6469_(damagesource, amount);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        OssukageEntityDiesProcedure.execute(source.m_7639_());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        OssukageOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Datatransform", ((Boolean)this.f_19804_.m_135370_(DATA_transform)).booleanValue());
        compound.m_128405_("DataAI", ((Integer)this.f_19804_.m_135370_(DATA_AI)).intValue());
        compound.m_128359_("Datastate", (String)this.f_19804_.m_135370_(DATA_state));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Datatransform")) {
            this.f_19804_.m_135381_(DATA_transform, (Object)compound.m_128471_("Datatransform"));
        }
        if (compound.m_128441_("DataAI")) {
            this.f_19804_.m_135381_(DATA_AI, (Object)compound.m_128451_("DataAI"));
        }
        if (compound.m_128441_("Datastate")) {
            this.f_19804_.m_135381_(DATA_state, (Object)compound.m_128461_("Datastate"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        NinjaSkeletonOnEntityTickUpdateProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
    }

    public boolean m_6063_() {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Level world = this.f_19853_;
        RemnantOssukageEntity entity = this;
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 64.0);
        return builder;
    }
}

