/*
 * Decompiled with CFR 0.152.
 */
package tn.naizo.remnants.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tn.naizo.remnants.entity.KunaiEntity;
import tn.naizo.remnants.entity.RatEntity;
import tn.naizo.remnants.entity.RemnantOssukageEntity;
import tn.naizo.remnants.entity.SkeletonMinionEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RemnantBossesModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"remnant_bosses");
    public static final RegistryObject<EntityType<KunaiEntity>> KUNAI = RemnantBossesModEntities.register("kunai", EntityType.Builder.m_20704_(KunaiEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(KunaiEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatEntity>> RAT = RemnantBossesModEntities.register("rat", EntityType.Builder.m_20704_(RatEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(RatEntity::new).m_20699_(1.2f, 1.0f));
    public static final RegistryObject<EntityType<SkeletonMinionEntity>> SKELETON_MINION = RemnantBossesModEntities.register("skeleton_minion", EntityType.Builder.m_20704_(SkeletonMinionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SkeletonMinionEntity::new).m_20699_(0.8f, 1.8f));
    public static final RegistryObject<EntityType<RemnantOssukageEntity>> REMNANT_OSSUKAGE = RemnantBossesModEntities.register("remnant_ossukage", EntityType.Builder.m_20704_(RemnantOssukageEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(RemnantOssukageEntity::new).m_20699_(0.8f, 2.4f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            RatEntity.init();
            SkeletonMinionEntity.init();
            RemnantOssukageEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)RAT.get(), RatEntity.createAttributes().m_22265_());
        event.put((EntityType)SKELETON_MINION.get(), SkeletonMinionEntity.createAttributes().m_22265_());
        event.put((EntityType)REMNANT_OSSUKAGE.get(), RemnantOssukageEntity.createAttributes().m_22265_());
    }
}

