/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.core;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.midnightdust.core.config.MidnightLibConfig;
import eu.midnightdust.lib.config.AutoCommand;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.UIManager;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="midnightlib")
public class MidnightLib {
    public static List<String> hiddenMods = new ArrayList<String>();
    public static final String MOD_ID = "midnightlib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"midnightlib");
    public static List<LiteralArgumentBuilder<CommandSourceStack>> commands = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();

    public void onInitializeClient() {
        try {
            if (Util.m_137581_() != Util.OS.OSX) {
                System.setProperty("java.awt.headless", "false");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("Error setting system look and feel", e);
        }
        MidnightLibConfig.init(MOD_ID, MidnightLibConfig.class);
    }

    public MidnightLib() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (remote, server) -> true));
        if (PlatformFunctions.isClientEnv()) {
            this.onInitializeClient();
        }
    }

    @Mod.EventBusSubscriber(modid="midnightlib")
    public static class MidnightLibEvents {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            try {
                commands.forEach(command -> event.getDispatcher().register(command));
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    @Mod.EventBusSubscriber(modid="midnightlib", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class MidnightLibBusEvents {
        @SubscribeEvent
        public static void onPostInit(FMLClientSetupEvent event) {
            ModList.get().forEachModContainer((modid, modContainer) -> {
                if (MidnightConfig.configInstances.containsKey(modid) && !hiddenMods.contains(modid)) {
                    modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraftClient, screen) -> MidnightConfig.getScreen(screen, modid)));
                }
            });
            new AutoCommand().onInitializeServer();
        }
    }
}

