/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.ButtonEntry;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightSliderWidget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.TextAndImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.GridLayoutTab;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class MidnightConfigScreen
extends Screen {
    public MidnightConfig instance;
    public final String translationPrefix;
    public final String modid;
    public final Screen parent;
    public MidnightConfigListWidget list;
    public TabManager tabManager = new TabManager(a -> {}, a -> {});
    public Map<String, Tab> tabs = new LinkedHashMap<String, Tab>();
    public Tab prevTab;
    public TabNavigationBar tabNavigation;
    public Button done;
    public double scrollProgress = 0.0;

    public MidnightConfigScreen(Screen parent, String modid) {
        super((Component)Component.m_237115_((String)(modid + ".midnightconfig.title")));
        this.parent = parent;
        this.modid = modid;
        this.translationPrefix = modid + ".midnightconfig.";
        this.instance = MidnightConfig.configInstances.get(modid);
        this.instance.loadValuesFromJson();
        MidnightConfig.entries.values().forEach(info -> {
            if (Objects.equals(info.modid, modid)) {
                String tabId = info.entry != null ? info.entry.category() : info.comment.category();
                String name = this.translationPrefix + "category." + tabId;
                if (!I18n.m_118936_((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    info.tab = new GridLayoutTab((Component)Component.m_237115_((String)name));
                    this.tabs.put(name, info.tab);
                } else {
                    info.tab = this.tabs.get(name);
                }
            }
        });
        this.tabNavigation = TabNavigationBar.m_267630_((TabManager)this.tabManager, (int)this.f_96543_).m_267824_(this.tabs.values().toArray(new Tab[0])).m_267625_();
        this.tabNavigation.m_276089_(0, false);
        this.tabNavigation.m_267766_();
        this.prevTab = this.tabManager.m_267695_();
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.prevTab != null && this.prevTab != this.tabManager.m_267695_()) {
            this.prevTab = this.tabManager.m_267695_();
            this.updateList();
            this.list.m_93410_(0.0);
        }
        this.scrollProgress = this.list.m_93517_();
        for (EntryInfo info : MidnightConfig.entries.values()) {
            if (!Objects.equals(this.modid, info.modid)) continue;
            info.updateFieldValue();
        }
        this.updateButtons();
        if (this.instance.reloadScreen) {
            this.updateList();
            this.instance.reloadScreen = false;
        }
    }

    public void updateButtons() {
        if (this.list == null) {
            return;
        }
        for (ButtonEntry entry : this.list.m_6702_()) {
            if (entry.buttons == null || entry.buttons.size() <= 1 || entry.info.field == null) continue;
            Optional.ofNullable(entry.buttons.get(0)).ifPresent(widget -> {
                if (widget.m_93696_() || widget.m_274382_()) {
                    widget.m_257544_(entry.info.getTooltip(true));
                }
            });
            AbstractWidget abstractWidget = entry.buttons.get(1);
            if (!(abstractWidget instanceof Button)) continue;
            Button button = (Button)abstractWidget;
            button.f_93623_ = !Objects.equals(String.valueOf(entry.info.value), String.valueOf(entry.info.defaultValue)) && entry.info.conditionsMet;
        }
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        return this.tabNavigation.m_269419_(key) || super.m_7933_(key, scanCode, modifiers);
    }

    public void m_7379_() {
        this.instance.loadValuesFromJson();
        MidnightConfig.entries.values().forEach(info -> {
            info.error = null;
            info.value = null;
            info.tempValue = null;
            info.actionButton = null;
            info.listIndex = 0;
            info.tab = null;
            info.inLimits = true;
        });
        Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
    }

    public void m_7856_() {
        super.m_7856_();
        this.tabNavigation.m_267604_(this.f_96543_);
        this.tabNavigation.m_267766_();
        if (this.tabs.size() > 1) {
            this.m_142416_((GuiEventListener)this.tabNavigation);
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 154, this.f_96544_ - 26, 150, 20).m_253136_());
        this.done = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            for (EntryInfo info : MidnightConfig.entries.values()) {
                if (!info.modid.equals(this.modid)) continue;
                info.updateFieldValue();
            }
            MidnightConfig.write(this.modid);
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ - 26, 150, 20).m_253136_());
        this.list = new MidnightConfigListWidget(this.f_96541_, this.f_96543_, this.f_96544_ - 57, 24, 25);
        this.m_7787_((GuiEventListener)this.list);
        this.updateList();
        if (this.tabs.size() > 1) {
            this.list.renderHeaderSeparator = false;
        }
    }

    public void updateList() {
        String string;
        this.list.clear();
        ComponentContents componentContents = this.prevTab.m_267600_().m_214077_();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            string = translatable.m_237508_().substring(translatable.m_237508_().lastIndexOf(46) + 1);
        } else {
            string = this.prevTab.m_267600_().toString();
        }
        this.instance.onTabInit(string, this.list, this);
        for (EntryInfo info : MidnightConfig.entries.values()) {
            info.updateConditions();
            if (!info.conditionsMet) {
                boolean visibleButLocked = false;
                for (MidnightConfig.Condition condition : info.conditions) {
                    visibleButLocked |= condition.visibleButLocked();
                }
                if (!visibleButLocked) continue;
            }
            if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.m_267695_())) {
                TextAndImageButton resetButton = TextAndImageButton.m_267772_((Component)Component.m_237115_((String)"controls.reset"), (ResourceLocation)new ResourceLocation("midnightlib", "icon/reset.png"), button -> {
                    info.value = info.defaultValue;
                    info.listIndex = 0;
                    info.tempValue = info.toTemporaryValue();
                    this.updateList();
                }).m_267643_(12, 12).m_267765_(12, 12).m_267570_(0, 4).m_267775_();
                resetButton.m_93674_(20);
                resetButton.m_264152_(this.f_96543_ - 205 + 150 + 25, 0);
                if (info.function != null) {
                    Object widget;
                    MidnightConfig.Entry e = info.entry;
                    if (info.function instanceof Map.Entry) {
                        Map.Entry values = (Map.Entry)info.function;
                        if (info.dataType.isEnum()) {
                            values.setValue(value -> this.instance.getEnumTranslatableText(value, info));
                        }
                        widget = Button.m_253074_((Component)((Component)((Function)values.getValue()).apply(info.value)), (Button.OnPress)((Button.OnPress)values.getKey())).m_252987_(this.f_96543_ - 185, 0, 150, 20).m_257505_(info.getTooltip(true)).m_253136_();
                    } else {
                        widget = e.isSlider() ? new MidnightSliderWidget(this.f_96543_ - 185, 0, 150, 20, Component.m_130674_((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new EditBox(this.f_96547_, this.f_96543_ - 185, 0, 150, 20, (Component)Component.m_237119_());
                    }
                    if (widget instanceof EditBox) {
                        EditBox textField = widget;
                        textField.m_94199_(e.width());
                        textField.m_94144_(info.tempValue);
                        Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                        textField.m_94153_(processor);
                    }
                    widget.m_257544_(info.getTooltip(true));
                    Button cycleButton = null;
                    if (info.field.getType() == List.class) {
                        cycleButton = Button.m_253074_((Component)Component.m_237113_((String)String.valueOf(info.listIndex)).m_130940_(ChatFormatting.GOLD), button -> {
                            List values = (List)info.value;
                            values.remove("");
                            info.listIndex = info.listIndex != values.size() ? info.listIndex + 1 : 0;
                            info.tempValue = info.listIndex != values.size() ? info.toTemporaryValue() : "";
                            this.updateList();
                        }).m_252987_(this.f_96543_ - 185, 0, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237110_((String)"midnightconfig.action.list_index", (Object[])new Object[]{info.listIndex}))).m_253136_();
                    }
                    if (e.isColor()) {
                        Button colorButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2b1b"), button -> new Thread(() -> {
                            Color newColor = JColorChooser.showDialog(null, Component.m_237115_((String)"midnightconfig.colorChooser.title").getString(), Color.decode(!Objects.equals(info.tempValue, "") ? info.tempValue : "#FFFFFF"));
                            if (newColor != null) {
                                info.setValue("#" + Integer.toHexString(newColor.getRGB()).substring(2));
                                this.updateList();
                            }
                        }).start()).m_252987_(this.f_96543_ - 185, 0, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"midnightconfig.action.color_chooser"))).m_253136_();
                        try {
                            colorButton.m_93666_((Component)Component.m_237113_((String)"\u2b1b").m_6270_(Style.f_131099_.m_178520_(Color.decode(info.tempValue).getRGB())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        info.actionButton = colorButton;
                    } else if (e.selectionMode() > -1) {
                        TextAndImageButton explorerButton = TextAndImageButton.m_267772_((Component)Component.m_237119_(), (ResourceLocation)new ResourceLocation("midnightlib", "icon/explorer.png"), button -> new Thread(() -> {
                            JFileChooser fileChooser = new JFileChooser(info.tempValue);
                            fileChooser.setFileSelectionMode(e.selectionMode());
                            fileChooser.setDialogType(e.fileChooserType());
                            fileChooser.setDialogTitle(Component.m_237115_((String)(this.translationPrefix + info.fieldName + ".fileChooser")).getString());
                            if ((e.selectionMode() == 0 || e.selectionMode() == 2) && Arrays.stream(e.fileExtensions()).noneMatch("*"::equals)) {
                                fileChooser.setFileFilter(new FileNameExtensionFilter(Component.m_237115_((String)(this.translationPrefix + info.fieldName + ".fileFilter")).getString(), e.fileExtensions()));
                            }
                            if (fileChooser.showDialog(null, null) == 0) {
                                info.setValue(fileChooser.getSelectedFile().getAbsolutePath());
                                this.updateList();
                            }
                        }).start()).m_267643_(12, 12).m_267765_(12, 12).m_267570_(0, 4).m_267775_();
                        explorerButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"midnightconfig.action.file_chooser")));
                        explorerButton.m_264152_(this.f_96543_ - 185, 0);
                        info.actionButton = explorerButton;
                    }
                    ArrayList widgets = Lists.newArrayList((Object[])new AbstractWidget[]{widget, resetButton});
                    if (info.actionButton != null) {
                        if (Util.m_137581_() == Util.OS.OSX) {
                            info.actionButton.f_93623_ = false;
                        }
                        widget.m_93674_(widget.m_5711_() - 22);
                        widget.m_252865_(widget.m_252754_() + 22);
                        widgets.add(info.actionButton);
                    }
                    if (cycleButton != null) {
                        if (info.actionButton != null) {
                            info.actionButton.m_252865_(info.actionButton.m_252754_() + 22);
                        }
                        widget.m_93674_(widget.m_5711_() - 22);
                        widget.m_252865_(widget.m_252754_() + 22);
                        widgets.add(cycleButton);
                    }
                    if (!info.conditionsMet) {
                        widgets.forEach(w -> {
                            w.f_93623_ = false;
                        });
                    }
                    this.list.addButton(widgets, (Component)Component.m_237115_((String)info.translationKey), info);
                } else {
                    this.list.addButton(List.of(), (Component)Component.m_237115_((String)info.translationKey), info);
                }
            }
            this.list.m_93410_(this.scrollProgress);
            this.updateButtons();
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_280273_(context);
        this.list.m_88315_(context, mouseX, mouseY, delta);
        if (this.tabs.size() < 2) {
            context.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, -1);
        }
        super.m_88315_(context, mouseX, mouseY, delta);
    }
}

