/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class EntryInfo {
    public MidnightConfig.Entry entry;
    public MidnightConfig.Comment comment;
    public MidnightConfig.Condition[] conditions;
    public final Field field;
    public final Class<?> dataType;
    public final String modid;
    public final String fieldName;
    public final String translationKey;
    int listIndex;
    Object defaultValue;
    Object value;
    Object function;
    String tempValue;
    boolean inLimits = true;
    Component error;
    AbstractWidget actionButton;
    Tab tab;
    boolean conditionsMet = true;

    public EntryInfo(Field field, String modid) {
        this.field = field;
        this.modid = modid;
        if (field != null) {
            this.fieldName = field.getName();
            this.dataType = MidnightConfig.getUnderlyingType(field);
            this.entry = field.getAnnotation(MidnightConfig.Entry.class);
            this.comment = field.getAnnotation(MidnightConfig.Comment.class);
            this.conditions = (MidnightConfig.Condition[])field.getAnnotationsByType(MidnightConfig.Condition.class);
        } else {
            this.fieldName = "";
            this.dataType = null;
        }
        this.translationKey = this.entry != null && !this.entry.name().isEmpty() ? this.entry.name() : (this.comment != null && !this.comment.name().isEmpty() ? this.comment.name() : modid + ".midnightconfig." + this.fieldName);
    }

    public void setValue(Object value) {
        if (this.field.getType() != List.class) {
            this.value = value;
            this.tempValue = value.toString();
        } else {
            this.writeList(this.listIndex, value);
            this.tempValue = this.toTemporaryValue();
        }
    }

    public String toTemporaryValue() {
        if (this.field.getType() != List.class) {
            return this.value.toString();
        }
        try {
            return ((List)this.value).get(this.listIndex).toString();
        }
        catch (Exception ignored) {
            return "";
        }
    }

    public void updateFieldValue() {
        try {
            if (this.field.get(null) != this.value) {
                MidnightConfig.entries.values().forEach(EntryInfo::updateConditions);
            }
            this.field.set(null, this.value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void updateConditions() {
        boolean prevConditionState = this.conditionsMet;
        if (this.conditions.length > 0) {
            this.conditionsMet = true;
        }
        for (MidnightConfig.Condition condition : this.conditions) {
            if (!condition.requiredModId().isEmpty() && !PlatformFunctions.isModLoaded(condition.requiredModId())) {
                this.conditionsMet = false;
            }
            String requiredOption = condition.requiredOption().contains(":") ? condition.requiredOption() : this.modid + ":" + condition.requiredOption();
            Optional.ofNullable(MidnightConfig.entries.get(requiredOption)).ifPresent(info -> this.conditionsMet &= List.of(condition.requiredValue()).contains(info.tempValue));
            if (!this.conditionsMet) break;
        }
        if (prevConditionState != this.conditionsMet) {
            MidnightConfig.configInstances.get((Object)this.modid).reloadScreen = true;
        }
    }

    public <T> void writeList(int index, T value) {
        List list = (List)this.value;
        if (index >= list.size()) {
            list.add(value);
        } else {
            list.set(index, value);
        }
    }

    public Tooltip getTooltip(boolean isButton) {
        String key = this.translationKey + (!isButton ? ".label" : "") + ".tooltip";
        return Tooltip.create((Component)(isButton && this.error != null ? this.error : (I18n.exists((String)key) ? Component.translatable((String)key) : Component.empty())));
    }
}

