/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.core;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.midnightdust.core.config.MidnightLibConfig;
import eu.midnightdust.lib.config.AutoCommand;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.util.PlatformFunctions;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.swing.UIManager;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="midnightlib")
public class MidnightLib {
    public static List<String> hiddenMods = new ArrayList<String>();
    public static final String MOD_ID = "midnightlib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"midnightlib");
    public static List<LiteralArgumentBuilder<CommandSourceStack>> commands = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();

    public void onInitializeClient() {
        try {
            if (Util.getPlatform() != Util.OS.OSX) {
                System.setProperty("java.awt.headless", "false");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("Error setting system look and feel", e);
        }
        MidnightLibConfig.init(MOD_ID, MidnightLibConfig.class);
    }

    public MidnightLib() {
        if (PlatformFunctions.isClientEnv()) {
            this.onInitializeClient();
        }
    }

    @EventBusSubscriber(modid="midnightlib")
    public static class MidnightLibEvents {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            try {
                commands.forEach(command -> event.getDispatcher().register(command));
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    @EventBusSubscriber(modid="midnightlib", value={Dist.CLIENT})
    public static class MidnightLibBusEvents {
        @SubscribeEvent
        public static void onPostInit(FMLClientSetupEvent event) {
            ModList.get().forEachModContainer((modid, modContainer) -> {
                if (MidnightConfig.configInstances.containsKey(modid) && !hiddenMods.contains(modid)) {
                    modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(minecraftClient, screen) -> MidnightConfig.getScreen(screen, modid)));
                }
            });
            new AutoCommand().onInitializeServer();
        }
    }
}

