/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.lib.config;

import com.google.common.collect.Lists;
import eu.midnightdust.lib.config.ButtonEntry;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightSliderWidget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7417;
import net.minecraft.class_7919;
import net.minecraft.class_8086;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8662;

public class MidnightConfigScreen
extends class_437 {
    public MidnightConfig instance;
    public final String translationPrefix;
    public final String modid;
    public final class_437 parent;
    public MidnightConfigListWidget list;
    public class_8088 tabManager = new class_8088(a -> {}, a -> {});
    public Map<String, class_8087> tabs = new LinkedHashMap<String, class_8087>();
    public class_8087 prevTab;
    public class_8089 tabNavigation;
    public class_4185 done;
    public double scrollProgress = 0.0;

    public MidnightConfigScreen(class_437 parent, String modid) {
        super((class_2561)class_2561.method_43471((String)(modid + ".midnightconfig.title")));
        this.parent = parent;
        this.modid = modid;
        this.translationPrefix = modid + ".midnightconfig.";
        this.instance = MidnightConfig.configInstances.get(modid);
        this.instance.loadValuesFromJson();
        MidnightConfig.entries.values().forEach(info -> {
            if (Objects.equals(info.modid, modid)) {
                String tabId = info.entry != null ? info.entry.category() : info.comment.category();
                String name = this.translationPrefix + "category." + tabId;
                if (!class_1074.method_4663((String)name) && tabId.equals("default")) {
                    name = this.translationPrefix + "title";
                }
                if (!this.tabs.containsKey(name)) {
                    info.tab = new class_8086((class_2561)class_2561.method_43471((String)name));
                    this.tabs.put(name, info.tab);
                } else {
                    info.tab = this.tabs.get(name);
                }
            }
        });
        this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(this.tabs.values().toArray(new class_8087[0])).method_48627();
        this.tabNavigation.method_48987(0, false);
        this.tabNavigation.method_49613();
        this.prevTab = this.tabManager.method_48614();
    }

    public void method_25393() {
        super.method_25393();
        if (this.prevTab != null && this.prevTab != this.tabManager.method_48614()) {
            this.prevTab = this.tabManager.method_48614();
            this.updateList();
            this.list.method_44382(0.0);
        }
        this.scrollProgress = this.list.method_44387();
        for (EntryInfo info : MidnightConfig.entries.values()) {
            if (!Objects.equals(this.modid, info.modid)) continue;
            info.updateFieldValue();
        }
        this.updateButtons();
        if (this.instance.reloadScreen) {
            this.updateList();
            this.instance.reloadScreen = false;
        }
    }

    public void updateButtons() {
        if (this.list == null) {
            return;
        }
        for (ButtonEntry entry : this.list.method_25396()) {
            if (entry.buttons == null || entry.buttons.size() <= 1 || entry.info.field == null) continue;
            Optional.ofNullable(entry.buttons.get(0)).ifPresent(widget -> {
                if (widget.method_25370() || widget.method_49606()) {
                    widget.method_47400(entry.info.getTooltip(true));
                }
            });
            class_339 class_3392 = entry.buttons.get(1);
            if (!(class_3392 instanceof class_4185)) continue;
            class_4185 button = (class_4185)class_3392;
            button.field_22763 = !Objects.equals(String.valueOf(entry.info.value), String.valueOf(entry.info.defaultValue)) && entry.info.conditionsMet;
        }
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        return this.tabNavigation.method_48988(key) || super.method_25404(key, scanCode, modifiers);
    }

    public void method_25419() {
        this.instance.loadValuesFromJson();
        MidnightConfig.entries.values().forEach(info -> {
            info.error = null;
            info.value = null;
            info.tempValue = null;
            info.actionButton = null;
            info.listIndex = 0;
            info.tab = null;
            info.inLimits = true;
        });
        Objects.requireNonNull(this.field_22787).method_1507(this.parent);
    }

    public void method_25426() {
        super.method_25426();
        this.tabNavigation.method_48618(this.field_22789);
        this.tabNavigation.method_49613();
        if (this.tabs.size() > 1) {
            this.method_37063((class_364)this.tabNavigation);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 26, 150, 20).method_46431());
        this.done = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
            for (EntryInfo info : MidnightConfig.entries.values()) {
                if (!info.modid.equals(this.modid)) continue;
                info.updateFieldValue();
            }
            MidnightConfig.write(this.modid);
            this.method_25419();
        }).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 26, 150, 20).method_46431());
        this.list = new MidnightConfigListWidget(this.field_22787, this.field_22789, this.field_22790 - 57, 24, 25);
        this.method_25429((class_364)this.list);
        this.updateList();
        if (this.tabs.size() > 1) {
            this.list.renderHeaderSeparator = false;
        }
    }

    public void updateList() {
        String string;
        this.list.clear();
        class_7417 class_74172 = this.prevTab.method_48610().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            string = translatable.method_11022().substring(translatable.method_11022().lastIndexOf(46) + 1);
        } else {
            string = this.prevTab.method_48610().toString();
        }
        this.instance.onTabInit(string, this.list, this);
        for (EntryInfo info : MidnightConfig.entries.values()) {
            info.updateConditions();
            if (!info.conditionsMet) {
                boolean visibleButLocked = false;
                for (MidnightConfig.Condition condition : info.conditions) {
                    visibleButLocked |= condition.visibleButLocked();
                }
                if (!visibleButLocked) continue;
            }
            if (info.modid.equals(this.modid) && (info.tab == null || info.tab == this.tabManager.method_48614())) {
                class_8662 resetButton = class_8662.method_52723((class_2561)class_2561.method_43471((String)"controls.reset"), button -> {
                    info.value = info.defaultValue;
                    info.listIndex = 0;
                    info.tempValue = info.toTemporaryValue();
                    this.updateList();
                }, (boolean)true).method_52727(class_2960.method_60655((String)"midnightlib", (String)"icon/reset"), 12, 12).method_52726(20, 20).method_52724();
                resetButton.method_48229(this.field_22789 - 205 + 150 + 25, 0);
                if (info.function != null) {
                    Object widget;
                    MidnightConfig.Entry e = info.entry;
                    if (info.function instanceof Map.Entry) {
                        Map.Entry values = (Map.Entry)info.function;
                        if (info.dataType.isEnum()) {
                            values.setValue(value -> this.instance.getEnumTranslatableText(value, info));
                        }
                        widget = class_4185.method_46430((class_2561)((class_2561)((Function)values.getValue()).apply(info.value)), (class_4185.class_4241)((class_4185.class_4241)values.getKey())).method_46434(this.field_22789 - 185, 0, 150, 20).method_46436(info.getTooltip(true)).method_46431();
                    } else {
                        widget = e.isSlider() ? new MidnightSliderWidget(this.field_22789 - 185, 0, 150, 20, class_2561.method_30163((String)info.tempValue), (Double.parseDouble(info.tempValue) - e.min()) / (e.max() - e.min()), info) : new class_342(this.field_22793, this.field_22789 - 185, 0, 150, 20, (class_2561)class_2561.method_43473());
                    }
                    if (widget instanceof class_342) {
                        class_342 textField = widget;
                        textField.method_1880(e.width());
                        textField.method_1852(info.tempValue);
                        Predicate processor = (Predicate)((BiFunction)info.function).apply(textField, this.done);
                        textField.method_1890(processor);
                    }
                    widget.method_47400(info.getTooltip(true));
                    class_4185 cycleButton = null;
                    if (info.field.getType() == List.class) {
                        cycleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(info.listIndex)).method_27692(class_124.field_1065), button -> {
                            List values = (List)info.value;
                            values.remove("");
                            info.listIndex = info.listIndex != values.size() ? info.listIndex + 1 : 0;
                            info.tempValue = info.listIndex != values.size() ? info.toTemporaryValue() : "";
                            this.updateList();
                        }).method_46434(this.field_22789 - 185, 0, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43469((String)"midnightconfig.action.list_index", (Object[])new Object[]{info.listIndex}))).method_46431();
                    }
                    if (e.isColor()) {
                        class_4185 colorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b1b"), button -> new Thread(() -> {
                            Color newColor = JColorChooser.showDialog(null, class_2561.method_43471((String)"midnightconfig.colorChooser.title").getString(), Color.decode(!Objects.equals(info.tempValue, "") ? info.tempValue : "#FFFFFF"));
                            if (newColor != null) {
                                info.setValue("#" + Integer.toHexString(newColor.getRGB()).substring(2));
                                this.updateList();
                            }
                        }).start()).method_46434(this.field_22789 - 185, 0, 20, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"midnightconfig.action.color_chooser"))).method_46431();
                        try {
                            colorButton.method_25355((class_2561)class_2561.method_43470((String)"\u2b1b").method_10862(class_2583.field_24360.method_36139(Color.decode(info.tempValue).getRGB())));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        info.actionButton = colorButton;
                    } else if (e.selectionMode() > -1) {
                        class_8662 explorerButton = class_8662.method_52723((class_2561)class_2561.method_43473(), button -> new Thread(() -> {
                            JFileChooser fileChooser = new JFileChooser(info.tempValue);
                            fileChooser.setFileSelectionMode(e.selectionMode());
                            fileChooser.setDialogType(e.fileChooserType());
                            fileChooser.setDialogTitle(class_2561.method_43471((String)(this.translationPrefix + info.fieldName + ".fileChooser")).getString());
                            if ((e.selectionMode() == 0 || e.selectionMode() == 2) && Arrays.stream(e.fileExtensions()).noneMatch("*"::equals)) {
                                fileChooser.setFileFilter(new FileNameExtensionFilter(class_2561.method_43471((String)(this.translationPrefix + info.fieldName + ".fileFilter")).getString(), e.fileExtensions()));
                            }
                            if (fileChooser.showDialog(null, null) == 0) {
                                info.setValue(fileChooser.getSelectedFile().getAbsolutePath());
                                this.updateList();
                            }
                        }).start(), (boolean)true).method_52727(class_2960.method_60655((String)"midnightlib", (String)"icon/explorer"), 12, 12).method_52726(20, 20).method_52724();
                        explorerButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"midnightconfig.action.file_chooser")));
                        explorerButton.method_48229(this.field_22789 - 185, 0);
                        info.actionButton = explorerButton;
                    }
                    ArrayList widgets = Lists.newArrayList((Object[])new class_339[]{widget, resetButton});
                    if (info.actionButton != null) {
                        if (class_156.method_668() == class_156.class_158.field_1137) {
                            info.actionButton.field_22763 = false;
                        }
                        widget.method_25358(widget.method_25368() - 22);
                        widget.method_46421(widget.method_46426() + 22);
                        widgets.add(info.actionButton);
                    }
                    if (cycleButton != null) {
                        if (info.actionButton != null) {
                            info.actionButton.method_46421(info.actionButton.method_46426() + 22);
                        }
                        widget.method_25358(widget.method_25368() - 22);
                        widget.method_46421(widget.method_46426() + 22);
                        widgets.add(cycleButton);
                    }
                    if (!info.conditionsMet) {
                        widgets.forEach(w -> {
                            w.field_22763 = false;
                        });
                    }
                    this.list.addButton(widgets, (class_2561)class_2561.method_43471((String)info.translationKey), info);
                } else {
                    this.list.addButton(List.of(), (class_2561)class_2561.method_43471((String)info.translationKey), info);
                }
            }
            this.list.method_44382(this.scrollProgress);
            this.updateButtons();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.list.method_25394(context, mouseX, mouseY, delta);
        if (this.tabs.size() < 2) {
            context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, -1);
        }
    }
}

