/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.api;

import java.util.Locale;
import java.util.Objects;

public enum RequirementType {
    NONE,
    CLIENT,
    SERVER,
    BOTH;


    public boolean requiredOnEither() {
        return this != NONE;
    }

    public boolean isRequiredOnServer() {
        return this == BOTH || this == SERVER;
    }

    public boolean isRequiredOnClient() {
        return this == BOTH || this == CLIENT;
    }

    public boolean supercedes(RequirementType requirement) {
        return this.ordinal() > requirement.ordinal();
    }

    public static RequirementType forKey(String key) {
        return switch (Objects.requireNonNullElse(key, "").toLowerCase(Locale.ROOT).trim()) {
            case "*" -> BOTH;
            case "client" -> CLIENT;
            case "server" -> SERVER;
            default -> NONE;
        };
    }
}

