/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.api.packets;

import com.google.common.base.Preconditions;
import com.sollace.fabwork.api.packets.Packet;
import com.sollace.fabwork.api.packets.Payload;
import com.sollace.fabwork.api.packets.Receiver;
import com.sollace.fabwork.impl.ClientConnectionAccessor;
import com.sollace.fabwork.impl.packets.ClientSimpleNetworkingImpl;
import com.sollace.fabwork.impl.packets.ServerSimpleNetworkingImpl;
import java.util.Objects;
import java.util.concurrent.Future;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_8609;
import net.minecraft.class_8706;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record C2SPacketType<T>(class_8710.class_9154<Payload<T>> id, class_9139<class_9129, Payload<T>> codec, Receiver<class_3222, T> receiver) {
    public void sendToServer(T packet) {
        Preconditions.checkState((FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? 1 : 0) != 0, (Object)"Client packet send called by the server");
        ClientSimpleNetworkingImpl.send(new Payload<T>(packet, this.id));
    }

    @Deprecated(forRemoval=true)
    public void sendToServer(Packet packet) {
        this.sendToServer((T)packet);
    }

    public Future<T> awaitResponseFrom(class_3222 client) {
        Objects.requireNonNull(client, "Client player cannot be null");
        return ServerSimpleNetworkingImpl.waitForReponse(this, ClientConnectionAccessor.get((class_8609)client.field_13987));
    }

    public class_2596<class_8706> toPacket(T packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        return ClientSimpleNetworkingImpl.createC2SPacket(new Payload<T>(packet, this.id));
    }

    @Deprecated(forRemoval=true)
    public class_2596<class_8706> toPacket(Packet packet) {
        return this.toPacket((T)packet);
    }
}

