/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.impl.packets;

import com.sollace.fabwork.api.packets.Handled;
import com.sollace.fabwork.api.packets.Receiver;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class ReceiverImpl<Sender, P>
implements Receiver<Sender, P> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ListenerList persistentListeners = new ListenerList();
    private final ListenerList listeners = new ListenerList();
    private final class_2960 id;

    ReceiverImpl(class_2960 id) {
        this.id = id;
    }

    @Override
    public void addPersistentListener(BiConsumer<Sender, P> callback) {
        this.persistentListeners.enqueue((p, t) -> {
            callback.accept(p, t);
            return false;
        });
    }

    @Override
    public void addTemporaryListener(BiPredicate<Sender, P> callback) {
        this.listeners.enqueue(callback);
    }

    void onReceive(Sender sender, P packet) {
        this.persistentListeners.fire(sender, packet);
        this.listeners.fire(sender, packet);
        if (packet instanceof Handled) {
            Handled handler = (Handled)packet;
            try {
                handler.handle(sender);
            }
            catch (Exception e) {
                LOGGER.error("Exception whilst handling packet callback for handled packet " + String.valueOf(this.id), (Throwable)e);
            }
        }
    }

    final class ListenerList {
        private final List<BiPredicate<Sender, P>> listeners = new ArrayList();

        ListenerList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enqueue(BiPredicate<Sender, P> listener) {
            ListenerList listenerList = this;
            synchronized (listenerList) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fire(Sender sender, P packet) {
            ArrayList handlers;
            ListenerList listenerList = this;
            synchronized (listenerList) {
                handlers = new ArrayList(this.listeners);
                this.listeners.clear();
            }
            handlers.removeIf(listener -> {
                try {
                    return listener.test(sender, packet);
                }
                catch (Exception e) {
                    LOGGER.error("Exception whilst handling packet callback for packet " + String.valueOf(ReceiverImpl.this.id), (Throwable)e);
                    return true;
                }
            });
            listenerList = this;
            synchronized (listenerList) {
                this.listeners.addAll(handlers);
            }
        }
    }
}

