/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.impl.packets;

import com.sollace.fabwork.api.packets.C2SPacketType;
import com.sollace.fabwork.api.packets.Payload;
import com.sollace.fabwork.api.packets.S2CPacketType;
import com.sollace.fabwork.impl.ClientConnectionAccessor;
import com.sollace.fabwork.impl.PlayPingSynchroniser;
import com.sollace.fabwork.impl.packets.ReceiverImpl;
import com.sollace.fabwork.impl.packets.Receivers;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.class_8609;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ServerSimpleNetworkingImpl {
    private ServerSimpleNetworkingImpl() {
        throw new RuntimeException("new ServerSimpleNetworkingImpl()");
    }

    public static <T> C2SPacketType<T> registerC2S(class_2960 id, class_9139<? super class_9129, T> codec) {
        class_8710.class_9154 packetId = new class_8710.class_9154(id);
        C2SPacketType type = new C2SPacketType(packetId, Payload.createCodec(packetId, codec), new ReceiverImpl(id));
        PayloadTypeRegistry.playC2S().register(type.id(), type.codec());
        ServerPlayNetworking.registerGlobalReceiver(type.id(), (payload, context) -> context.player().method_51469().method_8503().execute(() -> ((ReceiverImpl)type.receiver()).onReceive(context.player(), payload.packet())));
        return type;
    }

    public static <T> S2CPacketType<T> registerS2C(class_2960 id, class_9139<? super class_9129, T> codec) {
        class_8710.class_9154 packetId = new class_8710.class_9154(id);
        S2CPacketType<T> type = new S2CPacketType<T>(packetId, Payload.createCodec(packetId, codec), Receivers.empty(id));
        PayloadTypeRegistry.playS2C().register(type.id(), type.codec());
        return type;
    }

    public static <T> Future<T> waitForReponse(C2SPacketType<T> packetType, class_2535 connection) {
        Objects.requireNonNull(connection, "Client Connection cannot be null");
        if (!connection.method_10758()) {
            return CompletableFuture.failedFuture(new IOException("Connection is closed"));
        }
        Object[] receivedPacket = new Object[1];
        CompletableFuture future = new CompletableFuture();
        packetType.receiver().addTemporaryListener((sender, packet) -> {
            if (ClientConnectionAccessor.get((class_8609)sender.field_13987) == connection) {
                receivedPacket[0] = packet;
                return true;
            }
            return !future.isDone();
        });
        PlayPingSynchroniser.waitForClientResponse(connection, responseType -> {
            if (receivedPacket[0] == null || responseType == PlayPingSynchroniser.ResponseType.ABORTED) {
                future.completeExceptionally(new TimeoutException());
            } else {
                future.complete(receivedPacket[0]);
            }
        });
        return future;
    }
}

