/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reatomizer.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.mcreator.reatomizer.config.ReatomizerConfig;
import net.mcreator.reatomizer.network.ConfigSyncMessage;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8710;

public class ReatomizerModMenu
implements ModMenuApi {
    private static final String CONFIG_PATH = "config/reatomizer.json";

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> new ConfigViewerScreen(parent);
    }

    public static class ConfigViewerScreen
    extends class_437 {
        private final class_437 parent;
        private NumericEditBox fieldBundlesPerItem;
        private NumericEditBox fieldBundlesToFabricate;
        private NumericEditBox fieldBundlesPerEnchant;
        private NumericEditBox fieldRarityCommon;
        private NumericEditBox fieldRarityUncommon;
        private NumericEditBox fieldRarityRare;
        private NumericEditBox fieldRarityEpic;
        private class_342 fieldBlacklistInput;
        private class_4185 addBlacklistButton;
        private int blueprintScrollOffset = 0;
        private class_342 fieldAtomizerBlacklistInput;
        private class_4185 addAtomizerBlacklistButton;
        private int atomizerScrollOffset = 0;
        private String statusMessage = null;
        private int statusTicks = 0;
        private int statusColor = -1;
        private class_4185 saveButton = null;
        private boolean validBundlesPerItem = true;
        private boolean validBundlesToFabricate = true;
        private boolean validBundlesPerEnchant = true;
        private boolean validRarityCommon = true;
        private boolean validRarityUncommon = true;
        private boolean validRarityRare = true;
        private boolean validRarityEpic = true;

        public ConfigViewerScreen(class_437 parent) {
            super((class_2561)class_2561.method_43470((String)"Reatomizer Config"));
            this.parent = parent;
        }

        private void populateFieldsFromConfig() {
            try {
                ReatomizerConfig.load();
                if (ReatomizerConfig.INSTANCE != null) {
                    if (this.fieldBundlesPerItem != null) {
                        this.fieldBundlesPerItem.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.atomBundlesPerItem));
                    }
                    if (this.fieldBundlesToFabricate != null) {
                        this.fieldBundlesToFabricate.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.atomBundlesToFabricate));
                    }
                    if (this.fieldBundlesPerEnchant != null) {
                        this.fieldBundlesPerEnchant.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.atomBundlesPerEnchant));
                    }
                    if (this.fieldRarityCommon != null) {
                        this.fieldRarityCommon.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierCommon));
                    }
                    if (this.fieldRarityUncommon != null) {
                        this.fieldRarityUncommon.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierUncommon));
                    }
                    if (this.fieldRarityRare != null) {
                        this.fieldRarityRare.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierRare));
                    }
                    if (this.fieldRarityEpic != null) {
                        this.fieldRarityEpic.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierEpic));
                    }
                    ReatomizerConfig.clampAndSave();
                }
            }
            catch (Exception e) {
                this.statusMessage = "Failed to load config: " + e.getMessage();
                this.statusTicks = 120;
            }
        }

        private void validateFields() {
            boolean all;
            int v;
            String s;
            try {
                this.validBundlesPerItem = this.fieldBundlesPerItem != null ? ((s = this.fieldBundlesPerItem.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 0 && v <= 1000000) : true;
            }
            catch (Exception e) {
                this.validBundlesPerItem = false;
            }
            try {
                this.validBundlesToFabricate = this.fieldBundlesToFabricate != null ? ((s = this.fieldBundlesToFabricate.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 0 && v <= 1000000) : true;
            }
            catch (Exception e) {
                this.validBundlesToFabricate = false;
            }
            try {
                this.validBundlesPerEnchant = this.fieldBundlesPerEnchant != null ? ((s = this.fieldBundlesPerEnchant.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 0 && v <= 1000000) : true;
            }
            catch (Exception e) {
                this.validBundlesPerEnchant = false;
            }
            try {
                this.validRarityCommon = this.fieldRarityCommon != null ? ((s = this.fieldRarityCommon.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 1 && v <= 100) : true;
            }
            catch (Exception e) {
                this.validRarityCommon = false;
            }
            try {
                this.validRarityUncommon = this.fieldRarityUncommon != null ? ((s = this.fieldRarityUncommon.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 1 && v <= 100) : true;
            }
            catch (Exception e) {
                this.validRarityUncommon = false;
            }
            try {
                this.validRarityRare = this.fieldRarityRare != null ? ((s = this.fieldRarityRare.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 1 && v <= 100) : true;
            }
            catch (Exception e) {
                this.validRarityRare = false;
            }
            try {
                this.validRarityEpic = this.fieldRarityEpic != null ? ((s = this.fieldRarityEpic.method_1882().trim()).isEmpty() ? true : (v = Integer.parseInt(s)) >= 1 && v <= 100) : true;
            }
            catch (Exception e) {
                this.validRarityEpic = false;
            }
            boolean bl = all = this.validBundlesPerItem && this.validBundlesToFabricate && this.validBundlesPerEnchant && this.validRarityCommon && this.validRarityUncommon && this.validRarityRare && this.validRarityEpic;
            if (this.saveButton != null) {
                this.saveButton.field_22763 = all;
            }
        }

        protected void method_25426() {
            super.method_25426();
            int centerX = this.field_22789 / 2;
            int panelWidth = Math.min(650, Math.max(400, this.field_22789 - 40));
            int panelHeight = Math.min(380, Math.max(300, this.field_22790 - 80));
            int panelX = (this.field_22789 - panelWidth) / 2;
            int panelY = Math.max(10, (this.field_22790 - panelHeight) / 2 - 20);
            int col1X = panelX + 12;
            int col2X = panelX + panelWidth / 2 + 6;
            int fieldWidth = Math.max(40, Math.min(60, panelWidth / 2 - 180));
            int startY = panelY + 35;
            int rowGap = Math.max(18, Math.min(22, panelHeight / 17));
            this.fieldBundlesPerItem = new NumericEditBox(this.field_22793, col1X + 170, startY, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"atomBundlesPerItem"));
            this.fieldBundlesToFabricate = new NumericEditBox(this.field_22793, col1X + 170, startY + rowGap, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"atomBundlesToFabricate"));
            this.fieldBundlesPerEnchant = new NumericEditBox(this.field_22793, col1X + 170, startY + rowGap * 2, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"atomBundlesPerEnchant"));
            this.fieldRarityCommon = new NumericEditBox(this.field_22793, col2X + 180, startY, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"rarityMultiplierCommon"));
            this.fieldRarityUncommon = new NumericEditBox(this.field_22793, col2X + 180, startY + rowGap, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"rarityMultiplierUncommon"));
            this.fieldRarityRare = new NumericEditBox(this.field_22793, col2X + 180, startY + rowGap * 2, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"rarityMultiplierRare"));
            this.fieldRarityEpic = new NumericEditBox(this.field_22793, col2X + 180, startY + rowGap * 3, fieldWidth, 16, (class_2561)class_2561.method_43470((String)"rarityMultiplierEpic"));
            if (ReatomizerConfig.INSTANCE != null) {
                this.fieldBundlesPerItem.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.atomBundlesPerItem));
                this.fieldBundlesToFabricate.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.atomBundlesToFabricate));
                this.fieldBundlesPerEnchant.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.atomBundlesPerEnchant));
                this.fieldRarityCommon.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierCommon));
                this.fieldRarityUncommon.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierUncommon));
                this.fieldRarityRare.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierRare));
                this.fieldRarityEpic.method_1852(Integer.toString(ReatomizerConfig.INSTANCE.rarityMultiplierEpic));
            } else {
                this.fieldBundlesPerItem.method_1852("10");
                this.fieldBundlesToFabricate.method_1852("100");
                this.fieldBundlesPerEnchant.method_1852("15");
                this.fieldRarityCommon.method_1852(Integer.toString(1));
                this.fieldRarityUncommon.method_1852(Integer.toString(2));
                this.fieldRarityRare.method_1852(Integer.toString(3));
                this.fieldRarityEpic.method_1852(Integer.toString(5));
            }
            this.method_37063((class_364)this.fieldBundlesPerItem);
            this.method_37063((class_364)this.fieldBundlesToFabricate);
            this.method_37063((class_364)this.fieldBundlesPerEnchant);
            this.method_37063((class_364)this.fieldRarityCommon);
            this.method_37063((class_364)this.fieldRarityUncommon);
            this.method_37063((class_364)this.fieldRarityRare);
            this.method_37063((class_364)this.fieldRarityEpic);
            int blacklistY = startY + rowGap * 5 + 5;
            int blacklistFieldWidth = Math.max(150, Math.min(250, panelWidth / 2 - 80));
            this.fieldBlacklistInput = new class_342(this.field_22793, col1X, blacklistY, blacklistFieldWidth, 16, (class_2561)class_2561.method_43470((String)"blueprintBlacklistInput"));
            this.fieldBlacklistInput.method_47404((class_2561)class_2561.method_43470((String)"namespace:item"));
            this.method_37063((class_364)this.fieldBlacklistInput);
            this.addBlacklistButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> {
                String itemId = this.fieldBlacklistInput.method_1882().trim();
                if (!itemId.isEmpty()) {
                    if (ReatomizerConfig.INSTANCE.blueprintBlacklist == null) {
                        ReatomizerConfig.INSTANCE.blueprintBlacklist = new ArrayList<String>();
                    }
                    if (!ReatomizerConfig.INSTANCE.blueprintBlacklist.contains(itemId)) {
                        ReatomizerConfig.INSTANCE.blueprintBlacklist.add(itemId);
                        ReatomizerConfig.save();
                        this.fieldBlacklistInput.method_1852("");
                        this.statusMessage = "Added to blueprint blacklist!";
                        this.statusColor = 0xAAFFAA;
                        this.statusTicks = 160;
                    } else {
                        this.statusMessage = "Already in blueprint blacklist!";
                        this.statusColor = 0xFFAAAA;
                        this.statusTicks = 120;
                    }
                }
            }).method_46434(col1X + blacklistFieldWidth + 5, blacklistY, 55, 16).method_46431();
            this.method_37063((class_364)this.addBlacklistButton);
            this.fieldAtomizerBlacklistInput = new class_342(this.field_22793, col2X, blacklistY, blacklistFieldWidth, 16, (class_2561)class_2561.method_43470((String)"atomizerBlacklistInput"));
            this.fieldAtomizerBlacklistInput.method_47404((class_2561)class_2561.method_43470((String)"namespace:item"));
            this.method_37063((class_364)this.fieldAtomizerBlacklistInput);
            this.addAtomizerBlacklistButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), b -> {
                String itemId = this.fieldAtomizerBlacklistInput.method_1882().trim();
                if (!itemId.isEmpty()) {
                    if (ReatomizerConfig.INSTANCE.atomizerBlacklist == null) {
                        ReatomizerConfig.INSTANCE.atomizerBlacklist = new ArrayList<String>();
                    }
                    if (!ReatomizerConfig.INSTANCE.atomizerBlacklist.contains(itemId)) {
                        ReatomizerConfig.INSTANCE.atomizerBlacklist.add(itemId);
                        ReatomizerConfig.save();
                        this.fieldAtomizerBlacklistInput.method_1852("");
                        this.statusMessage = "Added to atomizer blacklist!";
                        this.statusColor = 0xAAFFAA;
                        this.statusTicks = 160;
                    } else {
                        this.statusMessage = "Already in atomizer blacklist!";
                        this.statusColor = 0xFFAAAA;
                        this.statusTicks = 120;
                    }
                }
            }).method_46434(col2X + blacklistFieldWidth + 5, blacklistY, 55, 16).method_46431();
            this.method_37063((class_364)this.addAtomizerBlacklistButton);
            this.fieldBundlesPerItem.method_1863(s -> this.validateFields());
            this.fieldBundlesToFabricate.method_1863(s -> this.validateFields());
            this.fieldBundlesPerEnchant.method_1863(s -> this.validateFields());
            this.fieldRarityCommon.method_1863(s -> this.validateFields());
            this.fieldRarityUncommon.method_1863(s -> this.validateFields());
            this.fieldRarityRare.method_1863(s -> this.validateFields());
            this.fieldRarityEpic.method_1863(s -> this.validateFields());
            this.populateFieldsFromConfig();
            this.validateFields();
            int buttonWidth = Math.max(80, Math.min(100, panelWidth / 5));
            int buttonHeight = 18;
            int buttonY = panelY + panelHeight - 26;
            int spacing = Math.max(4, Math.min(8, panelWidth / 80));
            int totalButtonWidth = buttonWidth * 4 + spacing * 3;
            int buttonStartX = (this.field_22789 - totalButtonWidth) / 2;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Open file"), b -> {
                try {
                    File alt;
                    String userDir;
                    File f = new File(ReatomizerModMenu.CONFIG_PATH);
                    if (!f.exists()) {
                        ReatomizerConfig.save();
                    }
                    if (!f.exists() && (userDir = System.getProperty("user.dir")) != null && !userDir.isEmpty() && (alt = new File(userDir, ReatomizerModMenu.CONFIG_PATH)).exists()) {
                        f = alt;
                    }
                    boolean opened = false;
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(f);
                            opened = true;
                        }
                        catch (Exception ex) {
                            opened = false;
                        }
                    }
                    if (!opened) {
                        String pathToOpen = f.getAbsolutePath();
                        String os = System.getProperty("os.name", "").toLowerCase();
                        try {
                            if (os.contains("win")) {
                                new ProcessBuilder("cmd", "/c", "start", "", pathToOpen).start();
                            } else if (os.contains("mac")) {
                                new ProcessBuilder("open", pathToOpen).start();
                            } else {
                                new ProcessBuilder("xdg-open", pathToOpen).start();
                            }
                            opened = true;
                        }
                        catch (Exception ex) {
                            opened = false;
                        }
                    }
                    if (opened) {
                        this.populateFieldsFromConfig();
                        this.statusMessage = "Opened config file.";
                        this.statusTicks = 160;
                    } else {
                        this.statusMessage = "Failed to open file on this platform.";
                        this.statusTicks = 160;
                    }
                }
                catch (Exception e) {
                    this.statusMessage = "Failed to open file: " + e.getMessage();
                    this.statusTicks = 160;
                }
            }).method_46434(buttonStartX, buttonY, buttonWidth, buttonHeight).method_46431());
            this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> {
                try {
                    int v1 = Integer.parseInt(this.fieldBundlesPerItem.method_1882().trim());
                    int v2 = Integer.parseInt(this.fieldBundlesToFabricate.method_1882().trim());
                    int v3 = Integer.parseInt(this.fieldBundlesPerEnchant.method_1882().trim());
                    int rCommon = Integer.parseInt(this.fieldRarityCommon.method_1882().trim());
                    int rUncommon = Integer.parseInt(this.fieldRarityUncommon.method_1882().trim());
                    int rRare = Integer.parseInt(this.fieldRarityRare.method_1882().trim());
                    int rEpic = Integer.parseInt(this.fieldRarityEpic.method_1882().trim());
                    if (ReatomizerConfig.INSTANCE != null) {
                        ReatomizerConfig.INSTANCE.atomBundlesPerItem = v1;
                        ReatomizerConfig.INSTANCE.atomBundlesToFabricate = v2;
                        ReatomizerConfig.INSTANCE.atomBundlesPerEnchant = v3;
                        ReatomizerConfig.INSTANCE.rarityMultiplierCommon = rCommon;
                        ReatomizerConfig.INSTANCE.rarityMultiplierUncommon = rUncommon;
                        ReatomizerConfig.INSTANCE.rarityMultiplierRare = rRare;
                        ReatomizerConfig.INSTANCE.rarityMultiplierEpic = rEpic;
                        ReatomizerConfig.save();
                    }
                    String extraJson = String.format("{\"rCommon\":%d,\"rUncommon\":%d,\"rRare\":%d,\"rEpic\":%d}", rCommon, rUncommon, rRare, rEpic);
                    try {
                        ClientPlayNetworking.send((class_8710)new ConfigSyncMessage(v1, v2, v3, false, false, extraJson));
                        this.statusMessage = "Saved successfully!";
                        this.statusColor = 0xAAFFAA;
                        this.statusTicks = 180;
                    }
                    catch (Throwable sendEx) {
                        this.statusMessage = "Config saved!";
                        this.statusColor = 0xAAFFAA;
                        this.statusTicks = 180;
                    }
                }
                catch (NumberFormatException ex) {
                    this.statusMessage = "Invalid number - enter digits only.";
                    this.statusColor = 0xFFAAAA;
                    this.statusTicks = 160;
                }
                catch (Exception ex) {
                    this.statusMessage = "Save failed: " + ex.getMessage();
                    this.statusColor = 0xFFAAAA;
                    this.statusTicks = 160;
                }
            }).method_46434(buttonStartX + buttonWidth + spacing, buttonY, buttonWidth, buttonHeight).method_46431();
            this.method_37063((class_364)this.saveButton);
            this.validateFields();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Back"), b -> {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parent);
                }
            }).method_46434(buttonStartX + (buttonWidth + spacing) * 2, buttonY, buttonWidth, buttonHeight).method_46431());
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Defaults"), b -> {
                this.fieldBundlesPerItem.method_1852(Integer.toString(1));
                this.fieldBundlesToFabricate.method_1852(Integer.toString(100));
                this.fieldBundlesPerEnchant.method_1852(Integer.toString(20));
                this.fieldRarityCommon.method_1852(Integer.toString(1));
                this.fieldRarityUncommon.method_1852(Integer.toString(2));
                this.fieldRarityRare.method_1852(Integer.toString(3));
                this.fieldRarityEpic.method_1852(Integer.toString(5));
                this.statusMessage = "Defaults loaded. Don't forget to save.";
                this.statusColor = 0xFFFFAA;
                this.statusTicks = 180;
                this.validateFields();
            }).method_46434(buttonStartX + (buttonWidth + spacing) * 3, buttonY, buttonWidth, buttonHeight).method_46431());
        }

        public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            int removeY;
            int removeX;
            String item;
            int i;
            int itemY;
            int endIndex;
            int startIndex;
            int totalItems;
            int maxVisibleItems;
            graphics.method_25294(0, 0, this.field_22789, this.field_22790, -15724528);
            int panelWidth = Math.min(650, Math.max(400, this.field_22789 - 40));
            int panelHeight = Math.min(380, Math.max(300, this.field_22790 - 80));
            int panelX = (this.field_22789 - panelWidth) / 2;
            int panelY = Math.max(10, (this.field_22790 - panelHeight) / 2 - 20);
            graphics.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -14013910);
            graphics.method_25294(panelX, panelY, panelX + panelWidth, panelY + 1, -1);
            graphics.method_25294(panelX, panelY + panelHeight - 1, panelX + panelWidth, panelY + panelHeight, -1);
            graphics.method_25294(panelX, panelY, panelX + 1, panelY + panelHeight, -1);
            graphics.method_25294(panelX + panelWidth - 1, panelY, panelX + panelWidth, panelY + panelHeight, -1);
            graphics.method_25300(this.field_22793, "Reatomizer Config", this.field_22789 / 2, panelY + 10, -1);
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            int col1X = panelX + 12;
            int col2X = panelX + panelWidth / 2 + 6;
            int startY = panelY + 35;
            int rowGap = Math.max(18, Math.min(22, panelHeight / 17));
            int col1 = this.validBundlesPerItem ? -1 : -32640;
            int col2 = this.validBundlesToFabricate ? -1 : -32640;
            int col3 = this.validBundlesPerEnchant ? -1 : -32640;
            graphics.method_51433(this.field_22793, "Atom bundles per item:", col1X, startY + 3, col1, false);
            graphics.method_51433(this.field_22793, "Atom bundles to fabricate:", col1X, startY + rowGap + 3, col2, false);
            graphics.method_51433(this.field_22793, "Atom bundles per enchant:", col1X, startY + rowGap * 2 + 3, col3, false);
            int rcol1 = this.validRarityCommon ? -1 : -32640;
            int rcol2 = this.validRarityUncommon ? -1 : -32640;
            int rcol3 = this.validRarityRare ? -1 : -32640;
            int rcol4 = this.validRarityEpic ? -1 : -32640;
            graphics.method_51433(this.field_22793, "Rarity multiplier (common):", col2X, startY + 3, rcol1, false);
            graphics.method_51433(this.field_22793, "Rarity multiplier (uncommon):", col2X, startY + rowGap + 3, rcol2, false);
            graphics.method_51433(this.field_22793, "Rarity multiplier (rare):", col2X, startY + rowGap * 2 + 3, rcol3, false);
            graphics.method_51433(this.field_22793, "Rarity multiplier (epic):", col2X, startY + rowGap * 3 + 3, rcol4, false);
            int blacklistY = startY + rowGap * 5 + 5;
            graphics.method_51433(this.field_22793, "Blueprint Blacklist:", col1X, blacklistY - 13, -1, false);
            int blacklistListY = blacklistY + 19;
            graphics.method_51433(this.field_22793, "Atomizer Blacklist:", col2X, blacklistY - 13, -1, false);
            if (ReatomizerConfig.INSTANCE.blueprintBlacklist != null && !ReatomizerConfig.INSTANCE.blueprintBlacklist.isEmpty()) {
                maxVisibleItems = 4;
                totalItems = ReatomizerConfig.INSTANCE.blueprintBlacklist.size();
                startIndex = Math.max(0, Math.min(this.blueprintScrollOffset, totalItems - maxVisibleItems));
                endIndex = Math.min(startIndex + maxVisibleItems, totalItems);
                itemY = blacklistListY;
                for (i = startIndex; i < endIndex; ++i) {
                    item = ReatomizerConfig.INSTANCE.blueprintBlacklist.get(i);
                    graphics.method_51433(this.field_22793, "\u2022 " + item, col1X + 10, itemY, -3355444, false);
                    removeX = col1X + panelWidth / 2 - 70;
                    removeY = itemY - 1;
                    if (mouseX >= removeX && mouseX <= removeX + 8 && mouseY >= removeY && mouseY <= removeY + 8) {
                        graphics.method_25294(removeX, removeY, removeX + 8, removeY + 8, -2130771968);
                    }
                    graphics.method_51433(this.field_22793, "X", removeX + 1, itemY, -48060, false);
                    itemY += 11;
                }
                if (totalItems > maxVisibleItems) {
                    String scrollText = "(" + (startIndex + 1) + "-" + endIndex + " of " + totalItems + ")";
                    graphics.method_51433(this.field_22793, scrollText, col1X + 10, itemY, -7829368, false);
                }
            } else {
                graphics.method_51433(this.field_22793, "(No items)", col1X + 10, blacklistListY, -7829368, false);
            }
            if (ReatomizerConfig.INSTANCE.atomizerBlacklist != null && !ReatomizerConfig.INSTANCE.atomizerBlacklist.isEmpty()) {
                maxVisibleItems = 4;
                totalItems = ReatomizerConfig.INSTANCE.atomizerBlacklist.size();
                startIndex = Math.max(0, Math.min(this.atomizerScrollOffset, totalItems - maxVisibleItems));
                endIndex = Math.min(startIndex + maxVisibleItems, totalItems);
                itemY = blacklistListY;
                for (i = startIndex; i < endIndex; ++i) {
                    item = ReatomizerConfig.INSTANCE.atomizerBlacklist.get(i);
                    graphics.method_51433(this.field_22793, "\u2022 " + item, col2X + 10, itemY, -3355444, false);
                    removeX = col2X + panelWidth / 2 - 70;
                    removeY = itemY - 1;
                    if (mouseX >= removeX && mouseX <= removeX + 8 && mouseY >= removeY && mouseY <= removeY + 8) {
                        graphics.method_25294(removeX, removeY, removeX + 8, removeY + 8, -2130771968);
                    }
                    graphics.method_51433(this.field_22793, "X", removeX + 1, itemY, -48060, false);
                    itemY += 11;
                }
                if (totalItems > maxVisibleItems) {
                    String scrollText = "(" + (startIndex + 1) + "-" + endIndex + " of " + totalItems + ")";
                    graphics.method_51433(this.field_22793, scrollText, col2X + 10, itemY, -7829368, false);
                }
            } else {
                graphics.method_51433(this.field_22793, "(No items)", col2X + 10, blacklistListY, -7829368, false);
            }
            if (this.statusMessage != null && this.statusTicks > 0) {
                int msgY = panelY + panelHeight - 50;
                int padding = 6;
                int textWidth = this.field_22793.method_1727(this.statusMessage);
                int msgX1 = this.field_22789 / 2 - textWidth / 2 - padding;
                int msgX2 = this.field_22789 / 2 + textWidth / 2 + padding;
                graphics.method_25294(msgX1 - 2, msgY - 2, msgX2 + 2, msgY + 14, -1442840576);
                graphics.method_25294(msgX1, msgY, msgX2, msgY + 12, this.statusColor);
                graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2 + 1, msgY + 4, -1442840576);
                graphics.method_25300(this.field_22793, this.statusMessage, this.field_22789 / 2, msgY + 3, -1);
                --this.statusTicks;
                if (this.statusTicks <= 0) {
                    this.statusMessage = null;
                }
            }
        }

        public void handleConfigSyncResponse(boolean success, String message, int v1, int v2, int v3) {
            if (success) {
                this.statusMessage = "Server saved config: " + (message == null || message.isEmpty() ? "OK" : message);
                this.statusColor = 0xAAFFAA;
                this.statusTicks = 120;
                try {
                    this.populateFieldsFromConfig();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.validateFields();
            } else {
                this.statusMessage = "Server save failed: " + (message == null ? "Unknown error" : message);
                this.statusColor = 0xFFAAAA;
                this.statusTicks = 160;
                try {
                    this.populateFieldsFromConfig();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.validateFields();
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 256) {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parent);
                }
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                int removeY;
                int removeX;
                int i;
                int itemY;
                int endIndex;
                int startIndex;
                int totalItems;
                int maxVisibleItems;
                int panelWidth = Math.min(650, Math.max(400, this.field_22789 - 40));
                int panelHeight = Math.min(380, Math.max(300, this.field_22790 - 80));
                int panelX = (this.field_22789 - panelWidth) / 2;
                int panelY = Math.max(10, (this.field_22790 - panelHeight) / 2 - 20);
                int col1X = panelX + 12;
                int col2X = panelX + panelWidth / 2 + 6;
                int startY = panelY + 35;
                int rowGap = Math.max(18, Math.min(22, panelHeight / 17));
                int blacklistY = startY + rowGap * 5 + 5;
                int blacklistListY = blacklistY + 19;
                if (ReatomizerConfig.INSTANCE.blueprintBlacklist != null && !ReatomizerConfig.INSTANCE.blueprintBlacklist.isEmpty()) {
                    maxVisibleItems = 4;
                    totalItems = ReatomizerConfig.INSTANCE.blueprintBlacklist.size();
                    startIndex = Math.max(0, Math.min(this.blueprintScrollOffset, totalItems - maxVisibleItems));
                    endIndex = Math.min(startIndex + maxVisibleItems, totalItems);
                    itemY = blacklistListY;
                    for (i = startIndex; i < endIndex; ++i) {
                        removeX = col1X + panelWidth / 2 - 70;
                        removeY = itemY - 1;
                        if (mouseX >= (double)removeX && mouseX <= (double)(removeX + 8) && mouseY >= (double)removeY && mouseY <= (double)(removeY + 8)) {
                            ReatomizerConfig.INSTANCE.blueprintBlacklist.remove(i);
                            ReatomizerConfig.save();
                            this.statusMessage = "Removed from blueprint blacklist!";
                            this.statusTicks = 160;
                            this.statusColor = 0xFFAAAA;
                            if (this.blueprintScrollOffset > 0 && ReatomizerConfig.INSTANCE.blueprintBlacklist.size() <= this.blueprintScrollOffset) {
                                this.blueprintScrollOffset = Math.max(0, this.blueprintScrollOffset - 1);
                            }
                            return true;
                        }
                        itemY += 11;
                    }
                }
                if (ReatomizerConfig.INSTANCE.atomizerBlacklist != null && !ReatomizerConfig.INSTANCE.atomizerBlacklist.isEmpty()) {
                    maxVisibleItems = 4;
                    totalItems = ReatomizerConfig.INSTANCE.atomizerBlacklist.size();
                    startIndex = Math.max(0, Math.min(this.atomizerScrollOffset, totalItems - maxVisibleItems));
                    endIndex = Math.min(startIndex + maxVisibleItems, totalItems);
                    itemY = blacklistListY;
                    for (i = startIndex; i < endIndex; ++i) {
                        removeX = col2X + panelWidth / 2 - 70;
                        removeY = itemY - 1;
                        if (mouseX >= (double)removeX && mouseX <= (double)(removeX + 8) && mouseY >= (double)removeY && mouseY <= (double)(removeY + 8)) {
                            ReatomizerConfig.INSTANCE.atomizerBlacklist.remove(i);
                            ReatomizerConfig.save();
                            this.statusMessage = "Removed from atomizer blacklist!";
                            this.statusTicks = 160;
                            this.statusColor = 0xFFAAAA;
                            if (this.atomizerScrollOffset > 0 && ReatomizerConfig.INSTANCE.atomizerBlacklist.size() <= this.atomizerScrollOffset) {
                                this.atomizerScrollOffset = Math.max(0, this.atomizerScrollOffset - 1);
                            }
                            return true;
                        }
                        itemY += 11;
                    }
                }
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25401(double mouseX, double mouseY, double horizontalScroll, double verticalScroll) {
            int totalItems;
            int maxVisibleItems;
            int panelWidth = Math.min(650, Math.max(400, this.field_22789 - 40));
            int panelHeight = Math.min(380, Math.max(300, this.field_22790 - 80));
            int panelX = (this.field_22789 - panelWidth) / 2;
            int panelY = Math.max(10, (this.field_22790 - panelHeight) / 2 - 20);
            int col1X = panelX + 12;
            int col2X = panelX + panelWidth / 2 + 12;
            int startY = panelY + 35;
            int rowGap = Math.max(18, Math.min(22, panelHeight / 17));
            int blacklistY = startY + rowGap * 5 + 5;
            int blacklistListY = blacklistY + 19;
            int blacklistAreaHeight = 50;
            if (mouseX >= (double)col1X && mouseX < (double)col2X && mouseY >= (double)blacklistListY && mouseY <= (double)(blacklistListY + blacklistAreaHeight) && ReatomizerConfig.INSTANCE.blueprintBlacklist != null && !ReatomizerConfig.INSTANCE.blueprintBlacklist.isEmpty()) {
                maxVisibleItems = 4;
                totalItems = ReatomizerConfig.INSTANCE.blueprintBlacklist.size();
                if (totalItems > maxVisibleItems) {
                    this.blueprintScrollOffset = Math.max(0, Math.min(totalItems - maxVisibleItems, this.blueprintScrollOffset - (int)verticalScroll));
                    return true;
                }
            }
            if (mouseX >= (double)col2X && mouseX < (double)(panelX + panelWidth) && mouseY >= (double)blacklistListY && mouseY <= (double)(blacklistListY + blacklistAreaHeight) && ReatomizerConfig.INSTANCE.atomizerBlacklist != null && !ReatomizerConfig.INSTANCE.atomizerBlacklist.isEmpty()) {
                maxVisibleItems = 4;
                totalItems = ReatomizerConfig.INSTANCE.atomizerBlacklist.size();
                if (totalItems > maxVisibleItems) {
                    this.atomizerScrollOffset = Math.max(0, Math.min(totalItems - maxVisibleItems, this.atomizerScrollOffset - (int)verticalScroll));
                    return true;
                }
            }
            return super.method_25401(mouseX, mouseY, horizontalScroll, verticalScroll);
        }

        private static class NumericEditBox
        extends class_342 {
            public NumericEditBox(class_327 font, int x, int y, int width, int height, class_2561 comp) {
                super(font, x, y, width, height, comp);
            }

            public boolean method_25400(char codePoint, int modifiers) {
                if (Character.isDigit(codePoint)) {
                    return super.method_25400(codePoint, modifiers);
                }
                return false;
            }

            public void method_1867(String text) {
                StringBuilder sb = new StringBuilder();
                for (char c : text.toCharArray()) {
                    if (!Character.isDigit(c)) continue;
                    sb.append(c);
                }
                if (sb.length() == 0) {
                    return;
                }
                super.method_1867(sb.toString());
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                try {
                    return super.method_25402(mouseX, mouseY, button);
                }
                catch (Throwable t) {
                    return false;
                }
            }
        }
    }
}

